/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.internal;

import android.util.Xml;
import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.common.utils.CRC64;
import com.alibaba.sdk.android.oss.common.utils.DateUtil;
import com.alibaba.sdk.android.oss.common.utils.OSSUtils;
import com.alibaba.sdk.android.oss.internal.AbstractResponseParser;
import com.alibaba.sdk.android.oss.internal.CheckCRC64DownloadInputStream;
import com.alibaba.sdk.android.oss.internal.ResponseMessage;
import com.alibaba.sdk.android.oss.model.AbortMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.AppendObjectResult;
import com.alibaba.sdk.android.oss.model.CompleteMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.CopyObjectResult;
import com.alibaba.sdk.android.oss.model.CreateBucketResult;
import com.alibaba.sdk.android.oss.model.DeleteBucketResult;
import com.alibaba.sdk.android.oss.model.DeleteObjectResult;
import com.alibaba.sdk.android.oss.model.GetBucketACLResult;
import com.alibaba.sdk.android.oss.model.GetObjectResult;
import com.alibaba.sdk.android.oss.model.HeadObjectResult;
import com.alibaba.sdk.android.oss.model.InitiateMultipartUploadResult;
import com.alibaba.sdk.android.oss.model.ListObjectsResult;
import com.alibaba.sdk.android.oss.model.ListPartsResult;
import com.alibaba.sdk.android.oss.model.OSSObjectSummary;
import com.alibaba.sdk.android.oss.model.ObjectMetadata;
import com.alibaba.sdk.android.oss.model.Owner;
import com.alibaba.sdk.android.oss.model.PartSummary;
import com.alibaba.sdk.android.oss.model.PutObjectResult;
import com.alibaba.sdk.android.oss.model.UploadPartResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ResponseParsers {
    private static CopyObjectResult parseCopyObjectResponseXML(InputStream in, CopyObjectResult result) throws XmlPullParserException, IOException, ParseException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if ("LastModified".equals(name)) {
                        result.setLastModified(DateUtil.parseIso8601Date(parser.nextText()));
                        break;
                    }
                    if (!"ETag".equals(name)) break;
                    result.setEtag(parser.nextText());
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        return result;
    }

    private static ListPartsResult parseListPartsResponseXML(InputStream in, ListPartsResult result) throws IOException, XmlPullParserException, ParseException {
        ArrayList<PartSummary> partEtagList = new ArrayList<PartSummary>();
        PartSummary partSummary = null;
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String size;
                    String name = parser.getName();
                    if ("Bucket".equals(name)) {
                        result.setBucketName(parser.nextText());
                        break;
                    }
                    if ("Key".equals(name)) {
                        result.setKey(parser.nextText());
                        break;
                    }
                    if ("UploadId".equals(name)) {
                        result.setUploadId(parser.nextText());
                        break;
                    }
                    if ("PartNumberMarker".equals(name)) {
                        String partNumberMarker = parser.nextText();
                        if (OSSUtils.isEmptyString(partNumberMarker)) break;
                        result.setPartNumberMarker(Integer.valueOf(partNumberMarker));
                        break;
                    }
                    if ("NextPartNumberMarker".equals(name)) {
                        String nextPartNumberMarker = parser.nextText();
                        if (OSSUtils.isEmptyString(nextPartNumberMarker)) break;
                        result.setNextPartNumberMarker(Integer.valueOf(nextPartNumberMarker));
                        break;
                    }
                    if ("MaxParts".equals(name)) {
                        String maxParts = parser.nextText();
                        if (OSSUtils.isEmptyString(maxParts)) break;
                        result.setMaxParts(Integer.valueOf(maxParts));
                        break;
                    }
                    if ("IsTruncated".equals(name)) {
                        String isTruncated = parser.nextText();
                        if (OSSUtils.isEmptyString(isTruncated)) break;
                        result.setTruncated(Boolean.valueOf(isTruncated));
                        break;
                    }
                    if ("StorageClass".equals(name)) {
                        result.setStorageClass(parser.nextText());
                        break;
                    }
                    if ("Part".equals(name)) {
                        partSummary = new PartSummary();
                        break;
                    }
                    if ("PartNumber".equals(name)) {
                        String partNum = parser.nextText();
                        if (OSSUtils.isEmptyString(partNum)) break;
                        partSummary.setPartNumber(Integer.valueOf(partNum));
                        break;
                    }
                    if ("LastModified".equals(name)) {
                        partSummary.setLastModified(DateUtil.parseIso8601Date(parser.nextText()));
                        break;
                    }
                    if ("ETag".equals(name)) {
                        partSummary.setETag(parser.nextText());
                        break;
                    }
                    if (!"Size".equals(name) || OSSUtils.isEmptyString(size = parser.nextText())) break;
                    partSummary.setSize(Long.valueOf(size));
                    break;
                }
                case 3: {
                    if (!"Part".equals(parser.getName())) break;
                    partEtagList.add(partSummary);
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        if (partEtagList.size() > 0) {
            result.setParts(partEtagList);
        }
        return result;
    }

    private static CompleteMultipartUploadResult parseCompleteMultipartUploadResponseXML(InputStream in, CompleteMultipartUploadResult result) throws IOException, XmlPullParserException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if ("Location".equals(name)) {
                        result.setLocation(parser.nextText());
                        break;
                    }
                    if ("Bucket".equals(name)) {
                        result.setBucketName(parser.nextText());
                        break;
                    }
                    if ("Key".equals(name)) {
                        result.setObjectKey(parser.nextText());
                        break;
                    }
                    if (!"ETag".equals(name)) break;
                    result.setETag(parser.nextText());
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        return result;
    }

    private static InitiateMultipartUploadResult parseInitMultipartResponseXML(InputStream in, InitiateMultipartUploadResult result) throws XmlPullParserException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if ("Bucket".equals(name)) {
                        result.setBucketName(parser.nextText());
                        break;
                    }
                    if ("Key".equals(name)) {
                        result.setObjectKey(parser.nextText());
                        break;
                    }
                    if (!"UploadId".equals(name)) break;
                    result.setUploadId(parser.nextText());
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        return result;
    }

    private static GetBucketACLResult parseGetBucketACLResponse(InputStream in, GetBucketACLResult result) throws XmlPullParserException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if ("Grant".equals(name)) {
                        result.setBucketACL(parser.nextText());
                        break;
                    }
                    if ("ID".equals(name)) {
                        result.setBucketOwnerID(parser.nextText());
                        break;
                    }
                    if (!"DisplayName".equals(name)) break;
                    result.setBucketOwner(parser.nextText());
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        return result;
    }

    private static ListObjectsResult parseObjectListResponse(InputStream in, ListObjectsResult result) throws XmlPullParserException, IOException, ParseException {
        result.clearCommonPrefixes();
        result.clearObjectSummaries();
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, "utf-8");
        int eventType = parser.getEventType();
        OSSObjectSummary object = null;
        Owner owner = null;
        boolean isCommonPrefixes = false;
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if ("Name".equals(name)) {
                        result.setBucketName(parser.nextText());
                        break;
                    }
                    if ("Prefix".equals(name)) {
                        if (isCommonPrefixes) {
                            String commonPrefix = parser.nextText();
                            if (OSSUtils.isEmptyString(commonPrefix)) break;
                            result.addCommonPrefix(commonPrefix);
                            break;
                        }
                        result.setPrefix(parser.nextText());
                        break;
                    }
                    if ("Marker".equals(name)) {
                        result.setMarker(parser.nextText());
                        break;
                    }
                    if ("Delimiter".equals(name)) {
                        result.setDelimiter(parser.nextText());
                        break;
                    }
                    if ("EncodingType".equals(name)) {
                        result.setEncodingType(parser.nextText());
                        break;
                    }
                    if ("MaxKeys".equals(name)) {
                        String maxKeys = parser.nextText();
                        if (OSSUtils.isEmptyString(maxKeys)) break;
                        result.setMaxKeys(Integer.valueOf(maxKeys));
                        break;
                    }
                    if ("NextMarker".equals(name)) {
                        result.setNextMarker(parser.nextText());
                        break;
                    }
                    if ("IsTruncated".equals(name)) {
                        String isTruncated = parser.nextText();
                        if (OSSUtils.isEmptyString(isTruncated)) break;
                        result.setTruncated(Boolean.valueOf(isTruncated));
                        break;
                    }
                    if ("Contents".equals(name)) {
                        object = new OSSObjectSummary();
                        break;
                    }
                    if ("Key".equals(name)) {
                        object.setKey(parser.nextText());
                        break;
                    }
                    if ("LastModified".equals(name)) {
                        object.setLastModified(DateUtil.parseIso8601Date(parser.nextText()));
                        break;
                    }
                    if ("Size".equals(name)) {
                        String size = parser.nextText();
                        if (OSSUtils.isEmptyString(size)) break;
                        object.setSize(Long.valueOf(size));
                        break;
                    }
                    if ("ETag".equals(name)) {
                        object.setETag(parser.nextText());
                        break;
                    }
                    if ("Type".equals(name)) {
                        object.setType(parser.nextText());
                        break;
                    }
                    if ("StorageClass".equals(name)) {
                        object.setStorageClass(parser.nextText());
                        break;
                    }
                    if ("Owner".equals(name)) {
                        owner = new Owner();
                        break;
                    }
                    if ("ID".equals(name)) {
                        owner.setId(parser.nextText());
                        break;
                    }
                    if ("DisplayName".equals(name)) {
                        owner.setDisplayName(parser.nextText());
                        break;
                    }
                    if (!"CommonPrefixes".equals(name)) break;
                    isCommonPrefixes = true;
                    break;
                }
                case 3: {
                    String endTagName = parser.getName();
                    if ("Owner".equals(parser.getName())) {
                        if (owner == null) break;
                        object.setOwner(owner);
                        break;
                    }
                    if ("Contents".equals(endTagName)) {
                        if (object == null) break;
                        object.setBucketName(result.getBucketName());
                        result.addObjectSummary(object);
                        break;
                    }
                    if (!"CommonPrefixes".equals(endTagName)) break;
                    isCommonPrefixes = false;
                }
            }
            if ((eventType = parser.next()) != 4) continue;
            eventType = parser.next();
        }
        return result;
    }

    public static String trimQuotes(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static ObjectMetadata parseObjectMetadata(Map<String, String> headers) throws IOException {
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            for (String key : headers.keySet()) {
                if (key.indexOf("x-oss-meta-") >= 0) {
                    objectMetadata.addUserMetadata(key, headers.get(key));
                    continue;
                }
                if (key.equals("Last-Modified") || key.equals("Date")) {
                    try {
                        objectMetadata.setHeader(key, DateUtil.parseRfc822Date(headers.get(key)));
                        continue;
                    }
                    catch (ParseException pe) {
                        throw new IOException(pe.getMessage(), pe);
                    }
                }
                if (key.equals("Content-Length")) {
                    Long value = Long.valueOf(headers.get(key));
                    objectMetadata.setHeader(key, value);
                    continue;
                }
                if (key.equals("ETag")) {
                    objectMetadata.setHeader(key, ResponseParsers.trimQuotes(headers.get(key)));
                    continue;
                }
                objectMetadata.setHeader(key, headers.get(key));
            }
            return objectMetadata;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static ServiceException parseResponseErrorXML(ResponseMessage response, boolean isHeadRequest) throws ClientException {
        int statusCode = response.getStatusCode();
        String requestId = response.getResponse().header("x-oss-request-id");
        String code = null;
        String message = null;
        String hostId = null;
        String errorMessage = null;
        if (!isHeadRequest) {
            try {
                errorMessage = response.getResponse().body().string();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(errorMessage.getBytes());
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput((InputStream)inputStream, "utf-8");
                int eventType = parser.getEventType();
                while (eventType != 1) {
                    switch (eventType) {
                        case 2: {
                            if ("Code".equals(parser.getName())) {
                                code = parser.nextText();
                                break;
                            }
                            if ("Message".equals(parser.getName())) {
                                message = parser.nextText();
                                break;
                            }
                            if ("RequestId".equals(parser.getName())) {
                                requestId = parser.nextText();
                                break;
                            }
                            if (!"HostId".equals(parser.getName())) break;
                            hostId = parser.nextText();
                        }
                    }
                    if ((eventType = parser.next()) != 4) continue;
                    eventType = parser.next();
                }
            }
            catch (IOException e) {
                throw new ClientException(e);
            }
            catch (XmlPullParserException e) {
                throw new ClientException(e);
            }
        }
        return new ServiceException(statusCode, message, code, requestId, hostId, errorMessage);
    }

    public static final class ListPartsResponseParser
    extends AbstractResponseParser<ListPartsResult> {
        @Override
        public ListPartsResult parseData(ResponseMessage response, ListPartsResult result) throws Exception {
            result = ResponseParsers.parseListPartsResponseXML(response.getContent(), result);
            return result;
        }
    }

    public static final class CompleteMultipartUploadResponseParser
    extends AbstractResponseParser<CompleteMultipartUploadResult> {
        @Override
        public CompleteMultipartUploadResult parseData(ResponseMessage response, CompleteMultipartUploadResult result) throws Exception {
            if (((String)response.getHeaders().get("Content-Type")).equals("application/xml")) {
                result = ResponseParsers.parseCompleteMultipartUploadResponseXML(response.getContent(), result);
            } else if (response.getResponse().body() != null) {
                result.setServerCallbackReturnBody(response.getResponse().body().string());
            }
            return result;
        }
    }

    public static final class AbortMultipartUploadResponseParser
    extends AbstractResponseParser<AbortMultipartUploadResult> {
        @Override
        public AbortMultipartUploadResult parseData(ResponseMessage response, AbortMultipartUploadResult result) throws IOException {
            return result;
        }
    }

    public static final class UploadPartResponseParser
    extends AbstractResponseParser<UploadPartResult> {
        @Override
        public UploadPartResult parseData(ResponseMessage response, UploadPartResult result) throws IOException {
            result.setETag(ResponseParsers.trimQuotes((String)response.getHeaders().get("ETag")));
            return result;
        }
    }

    public static final class InitMultipartResponseParser
    extends AbstractResponseParser<InitiateMultipartUploadResult> {
        @Override
        public InitiateMultipartUploadResult parseData(ResponseMessage response, InitiateMultipartUploadResult result) throws Exception {
            return ResponseParsers.parseInitMultipartResponseXML(response.getContent(), result);
        }
    }

    public static final class ListObjectsResponseParser
    extends AbstractResponseParser<ListObjectsResult> {
        @Override
        public ListObjectsResult parseData(ResponseMessage response, ListObjectsResult result) throws Exception {
            result = ResponseParsers.parseObjectListResponse(response.getContent(), result);
            return result;
        }
    }

    public static final class DeleteObjectResponseParser
    extends AbstractResponseParser<DeleteObjectResult> {
        @Override
        public DeleteObjectResult parseData(ResponseMessage response, DeleteObjectResult result) throws IOException {
            return result;
        }
    }

    public static final class GetBucketACLResponseParser
    extends AbstractResponseParser<GetBucketACLResult> {
        @Override
        public GetBucketACLResult parseData(ResponseMessage response, GetBucketACLResult result) throws Exception {
            result = ResponseParsers.parseGetBucketACLResponse(response.getContent(), result);
            return result;
        }
    }

    public static final class DeleteBucketResponseParser
    extends AbstractResponseParser<DeleteBucketResult> {
        @Override
        public DeleteBucketResult parseData(ResponseMessage response, DeleteBucketResult result) throws IOException {
            return result;
        }
    }

    public static final class CreateBucketResponseParser
    extends AbstractResponseParser<CreateBucketResult> {
        @Override
        public CreateBucketResult parseData(ResponseMessage response, CreateBucketResult result) throws IOException {
            if (result.getResponseHeader().containsKey("Location")) {
                result.bucketLocation = result.getResponseHeader().get("Location");
            }
            return result;
        }
    }

    public static final class CopyObjectResponseParser
    extends AbstractResponseParser<CopyObjectResult> {
        @Override
        public CopyObjectResult parseData(ResponseMessage response, CopyObjectResult result) throws Exception {
            result = ResponseParsers.parseCopyObjectResponseXML(response.getContent(), result);
            return result;
        }
    }

    public static final class GetObjectResponseParser
    extends AbstractResponseParser<GetObjectResult> {
        @Override
        public GetObjectResult parseData(ResponseMessage response, GetObjectResult result) throws IOException {
            result.setMetadata(ResponseParsers.parseObjectMetadata(result.getResponseHeader()));
            result.setContentLength(response.getContentLength());
            if (response.getRequest().isCheckCRC64()) {
                result.setObjectContent(new CheckCRC64DownloadInputStream(response.getContent(), new CRC64(), response.getContentLength(), result.getServerCRC(), result.getRequestId()));
            } else {
                result.setObjectContent(response.getContent());
            }
            return result;
        }

        @Override
        public boolean needCloseResponse() {
            return false;
        }
    }

    public static final class HeadObjectResponseParser
    extends AbstractResponseParser<HeadObjectResult> {
        @Override
        public HeadObjectResult parseData(ResponseMessage response, HeadObjectResult result) throws IOException {
            result.setMetadata(ResponseParsers.parseObjectMetadata(result.getResponseHeader()));
            return result;
        }
    }

    public static final class AppendObjectResponseParser
    extends AbstractResponseParser<AppendObjectResult> {
        @Override
        public AppendObjectResult parseData(ResponseMessage response, AppendObjectResult result) throws IOException {
            String nextPosition = (String)response.getHeaders().get("x-oss-next-append-position");
            if (nextPosition != null) {
                result.setNextPosition(Long.valueOf(nextPosition));
            }
            result.setObjectCRC64((String)response.getHeaders().get("x-oss-hash-crc64ecma"));
            return result;
        }
    }

    public static final class PutObjectResponseParser
    extends AbstractResponseParser<PutObjectResult> {
        @Override
        public PutObjectResult parseData(ResponseMessage response, PutObjectResult result) throws IOException {
            result.setETag(ResponseParsers.trimQuotes((String)response.getHeaders().get("ETag")));
            if (response.getContentLength() > 0L) {
                result.setServerCallbackReturnBody(response.getResponse().body().string());
            }
            return result;
        }
    }
}

