/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.model;

import com.alibaba.sdk.android.oss.common.utils.DateUtil;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ObjectMetadata {
    private Map<String, String> userMetadata = new HashMap<String, String>();
    private Map<String, Object> metadata = new HashMap<String, Object>();
    public static final String AES_256_SERVER_SIDE_ENCRYPTION = "AES256";

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata.clear();
        if (userMetadata != null && !userMetadata.isEmpty()) {
            this.userMetadata.putAll(userMetadata);
        }
    }

    public void setHeader(String key, Object value) {
        this.metadata.put(key, value);
    }

    public void addUserMetadata(String key, String value) {
        this.userMetadata.put(key, value);
    }

    public Date getLastModified() {
        return (Date)this.metadata.get("Last-Modified");
    }

    public void setLastModified(Date lastModified) {
        this.metadata.put("Last-Modified", lastModified);
    }

    public Date getExpirationTime() throws ParseException {
        return DateUtil.parseRfc822Date((String)this.metadata.get("Expires"));
    }

    public String getRawExpiresValue() {
        return (String)this.metadata.get("Expires");
    }

    public void setExpirationTime(Date expirationTime) {
        this.metadata.put("Expires", DateUtil.formatRfc822Date(expirationTime));
    }

    public long getContentLength() {
        Long contentLength = (Long)this.metadata.get("Content-Length");
        if (contentLength == null) {
            return 0L;
        }
        return contentLength;
    }

    public void setContentLength(long contentLength) {
        if (contentLength > 0x140000000L) {
            throw new IllegalArgumentException("The content length could not be more than 5GB.");
        }
        this.metadata.put("Content-Length", contentLength);
    }

    public String getContentType() {
        return (String)this.metadata.get("Content-Type");
    }

    public void setContentType(String contentType) {
        this.metadata.put("Content-Type", contentType);
    }

    public String getContentMD5() {
        return (String)this.metadata.get("Content-MD5");
    }

    public void setContentMD5(String contentMD5) {
        this.metadata.put("Content-MD5", contentMD5);
    }

    public String getContentEncoding() {
        return (String)this.metadata.get("Content-Encoding");
    }

    public void setContentEncoding(String encoding) {
        this.metadata.put("Content-Encoding", encoding);
    }

    public String getCacheControl() {
        return (String)this.metadata.get("Cache-Control");
    }

    public void setCacheControl(String cacheControl) {
        this.metadata.put("Cache-Control", cacheControl);
    }

    public String getContentDisposition() {
        return (String)this.metadata.get("Content-Disposition");
    }

    public void setContentDisposition(String disposition) {
        this.metadata.put("Content-Disposition", disposition);
    }

    public String getETag() {
        return (String)this.metadata.get("ETag");
    }

    public String getServerSideEncryption() {
        return (String)this.metadata.get("x-oss-server-side-encryption");
    }

    public void setServerSideEncryption(String serverSideEncryption) {
        this.metadata.put("x-oss-server-side-encryption", serverSideEncryption);
    }

    public String getObjectType() {
        return (String)this.metadata.get("x-oss-object-type");
    }

    public Map<String, Object> getRawMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public String toString() {
        String expirationTimeStr = "";
        try {
            Date expirationTime = this.getExpirationTime();
            expirationTimeStr = expirationTime.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String s = "Last-Modified:" + this.getLastModified() + "\n" + "Expires" + ":" + expirationTimeStr + "\n" + "rawExpires" + ":" + this.getRawExpiresValue() + "\n" + "Content-MD5" + ":" + this.getContentMD5() + "\n" + "x-oss-object-type" + ":" + this.getObjectType() + "\n" + "x-oss-server-side-encryption" + ":" + this.getServerSideEncryption() + "\n" + "Content-Disposition" + ":" + this.getContentDisposition() + "\n" + "Content-Encoding" + ":" + this.getContentEncoding() + "\n" + "Cache-Control" + ":" + this.getCacheControl() + "\n" + "ETag" + ":" + this.getETag() + "\n";
        return s;
    }
}

