/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.internal;

import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.ServiceException;
import com.alibaba.sdk.android.oss.common.OSSLog;
import com.alibaba.sdk.android.oss.common.utils.DateUtil;
import com.alibaba.sdk.android.oss.internal.OSSRetryType;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.text.ParseException;

public class OSSRetryHandler {
    private int maxRetryCount = 2;

    public OSSRetryHandler(int maxRetryCount) {
        this.setMaxRetryCount(maxRetryCount);
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public OSSRetryType shouldRetry(Exception e, int currentRetryCount) {
        if (currentRetryCount >= this.maxRetryCount) {
            return OSSRetryType.OSSRetryTypeShouldNotRetry;
        }
        if (e instanceof ClientException) {
            if (((ClientException)e).isCanceledException().booleanValue()) {
                return OSSRetryType.OSSRetryTypeShouldNotRetry;
            }
            Exception localException = (Exception)e.getCause();
            if (localException instanceof InterruptedIOException && !(localException instanceof SocketTimeoutException)) {
                OSSLog.logError("[shouldRetry] - is interrupted!");
                return OSSRetryType.OSSRetryTypeShouldNotRetry;
            }
            if (localException instanceof IllegalArgumentException) {
                return OSSRetryType.OSSRetryTypeShouldNotRetry;
            }
            OSSLog.logDebug("shouldRetry - " + e.toString());
            e.getCause().printStackTrace();
            return OSSRetryType.OSSRetryTypeShouldRetry;
        }
        if (e instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)e;
            if (serviceException.getErrorCode() != null && serviceException.getErrorCode().equalsIgnoreCase("RequestTimeTooSkewed")) {
                return OSSRetryType.OSSRetryTypeShouldFixedTimeSkewedAndRetry;
            }
            if (serviceException.getErrorCode() != null && serviceException.getMessage() != null && serviceException.getErrorCode().equalsIgnoreCase("InvalidArgument") && serviceException.getMessage().equalsIgnoreCase("Invalid signing date in Authorization header.")) {
                try {
                    String responseDateString = serviceException.getDate();
                    if (responseDateString == null) {
                        return OSSRetryType.OSSRetryTypeShouldNotRetry;
                    }
                    long serverTime = DateUtil.parseRfc822Date(responseDateString).getTime();
                    long timeDifference = DateUtil.getFixedSkewedTimeMillis() - serverTime;
                    if (timeDifference > 900000L || timeDifference < -900000L) {
                        return OSSRetryType.OSSRetryTypeShouldFixedTimeSkewedAndRetry;
                    }
                    return OSSRetryType.OSSRetryTypeShouldNotRetry;
                }
                catch (ParseException ex) {
                    OSSLog.logThrowable2Local(ex);
                    return OSSRetryType.OSSRetryTypeShouldNotRetry;
                }
            }
            if (serviceException.getStatusCode() >= 500) {
                return OSSRetryType.OSSRetryTypeShouldRetry;
            }
            return OSSRetryType.OSSRetryTypeShouldNotRetry;
        }
        return OSSRetryType.OSSRetryTypeShouldNotRetry;
    }

    public long timeInterval(int currentRetryCount, OSSRetryType retryType) {
        switch (retryType) {
            case OSSRetryTypeShouldRetry: {
                return (long)Math.pow(2.0, currentRetryCount) * 200L;
            }
        }
        return 0L;
    }
}

