/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.hitsdb.client.Config;
import com.aliyun.hitsdb.client.callback.AbstractMultiFieldBatchPutCallback;
import com.aliyun.hitsdb.client.callback.MultiFieldBatchPutCallback;
import com.aliyun.hitsdb.client.callback.MultiFieldBatchPutDetailsCallback;
import com.aliyun.hitsdb.client.callback.MultiFieldBatchPutIgnoreErrorsCallback;
import com.aliyun.hitsdb.client.callback.MultiFieldBatchPutSummaryCallback;
import com.aliyun.hitsdb.client.consumer.AbstractBatchPutRunnable;
import com.aliyun.hitsdb.client.http.HttpClient;
import com.aliyun.hitsdb.client.queue.DataQueue;
import com.aliyun.hitsdb.client.util.guava.RateLimiter;
import com.aliyun.hitsdb.client.value.request.MultiFieldPoint;
import com.aliyun.hitsdb.client.value.request.UniqueUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiFieldBatchPutRunnable
extends AbstractBatchPutRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiFieldBatchPutRunnable.class);
    private final AbstractMultiFieldBatchPutCallback<?> multiFieldBatchPutCallback;

    public MultiFieldBatchPutRunnable(DataQueue dataQueue, HttpClient httpclient, Config config, CountDownLatch countDownLatch, RateLimiter rateLimiter) {
        super(dataQueue, httpclient, countDownLatch, config, rateLimiter);
        this.multiFieldBatchPutCallback = config.getMultiFieldBatchPutCallback();
    }

    @Override
    public void run() {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        if (this.multiFieldBatchPutCallback != null && !(this.multiFieldBatchPutCallback instanceof MultiFieldBatchPutCallback)) {
            if (this.multiFieldBatchPutCallback instanceof MultiFieldBatchPutSummaryCallback) {
                paramsMap.put("summary", "true");
            } else if (this.multiFieldBatchPutCallback instanceof MultiFieldBatchPutDetailsCallback) {
                paramsMap.put("details", "true");
            } else if (this.multiFieldBatchPutCallback instanceof MultiFieldBatchPutIgnoreErrorsCallback) {
                paramsMap.put("ignoreErrors", "true");
            }
        }
        MultiFieldPoint waitPoint = null;
        boolean readyClose = false;
        int waitTimeLimit = this.batchPutTimeLimit / 3;
        while (!readyClose || waitPoint != null) {
            long t0 = System.currentTimeMillis();
            ArrayList<MultiFieldPoint> pointList = new ArrayList<MultiFieldPoint>(this.batchSize);
            if (waitPoint != null) {
                pointList.add(waitPoint);
                waitPoint = null;
            }
            for (int i = pointList.size(); i < this.batchSize; ++i) {
                try {
                    long t1;
                    MultiFieldPoint point = this.dataQueue.receiveMultiFieldPoint(waitTimeLimit);
                    if (point != null) {
                        if (this.rateLimiter != null) {
                            this.rateLimiter.acquire();
                        }
                        pointList.add(point);
                    }
                    if ((t1 = System.currentTimeMillis()) - t0 <= (long)this.batchPutTimeLimit) continue;
                }
                catch (InterruptedException e) {
                    readyClose = true;
                    LOGGER.info("The thread {} is interrupted", (Object)Thread.currentThread().getName());
                }
                break;
            }
            if (pointList.size() == 0 && !readyClose) {
                try {
                    MultiFieldPoint newPoint;
                    waitPoint = newPoint = this.dataQueue.receiveMultiFieldPoint();
                    continue;
                }
                catch (InterruptedException e) {
                    readyClose = true;
                    LOGGER.info("The thread {} is interrupted", (Object)Thread.currentThread().getName());
                }
            }
            if (pointList.size() == 0) continue;
            UniqueUtil.uniqueMultiFieldPoints(pointList, this.config.isDeduplicationEnable());
            String strJson = this.serialize(pointList);
            this.sendHttpRequest(pointList, strJson, paramsMap);
        }
        if (readyClose) {
            this.countDownLatch.countDown();
        }
    }

    private void sendHttpRequest(List<MultiFieldPoint> pointList, String strJson, Map<String, String> paramsMap) {
        String address = this.getAddressAndSemaphoreAcquire();
        if (this.multiFieldBatchPutCallback != null) {
            FutureCallback<HttpResponse> postHttpCallback = this.httpResponseCallbackFactory.createMultiFieldBatchPutDataCallback(address, this.multiFieldBatchPutCallback, pointList, this.config, this.config.getBatchPutRetryCount());
            try {
                this.tsdbHttpClient.postToAddress(address, "/api/mput", strJson, paramsMap, postHttpCallback);
            }
            catch (Exception ex) {
                this.semaphoreManager.release(address);
                this.multiFieldBatchPutCallback.failed(address, pointList, ex);
            }
        } else {
            FutureCallback<HttpResponse> noLogicBatchPutHttpFutureCallback = this.httpResponseCallbackFactory.createMultiFieldNoLogicBatchPutHttpFutureCallback(address, pointList, this.config, this.config.getBatchPutRetryCount());
            try {
                this.tsdbHttpClient.postToAddress(address, "/api/mput", strJson, noLogicBatchPutHttpFutureCallback);
            }
            catch (Exception ex) {
                this.semaphoreManager.release(address);
                noLogicBatchPutHttpFutureCallback.failed(ex);
            }
        }
    }

    private String serialize(List<MultiFieldPoint> pointList) {
        return JSON.toJSONString(pointList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }
}

