/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.consumer;

import com.aliyun.hitsdb.client.Config;
import com.aliyun.hitsdb.client.callback.AbstractBatchPutCallback;
import com.aliyun.hitsdb.client.callback.AbstractMultiFieldBatchPutCallback;
import com.aliyun.hitsdb.client.callback.BatchPutCallback;
import com.aliyun.hitsdb.client.callback.BatchPutDetailsCallback;
import com.aliyun.hitsdb.client.callback.BatchPutSummaryCallback;
import com.aliyun.hitsdb.client.callback.MultiFieldBatchPutCallback;
import com.aliyun.hitsdb.client.callback.MultiFieldBatchPutDetailsCallback;
import com.aliyun.hitsdb.client.callback.MultiFieldBatchPutSummaryCallback;
import com.aliyun.hitsdb.client.consumer.AbstractBatchPutRunnable;
import com.aliyun.hitsdb.client.http.HttpClient;
import com.aliyun.hitsdb.client.queue.DataQueue;
import com.aliyun.hitsdb.client.util.guava.RateLimiter;
import com.aliyun.hitsdb.client.value.request.MultiFieldPoint;
import com.aliyun.hitsdb.client.value.request.Point;
import com.aliyun.hitsdb.client.value.request.PointsCollection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointsCollectionPutRunnable
extends AbstractBatchPutRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PointsCollectionPutRunnable.class);

    public PointsCollectionPutRunnable(DataQueue dataQueue, HttpClient httpclient, CountDownLatch countDownLatch, Config config, RateLimiter rateLimiter) {
        super(dataQueue, httpclient, countDownLatch, config, rateLimiter);
    }

    @Override
    public void run() {
        boolean readyClose = false;
        int waitTimeLimit = this.batchPutTimeLimit / 3;
        while (!readyClose) {
            PointsCollection points;
            long t0 = System.currentTimeMillis();
            try {
                points = this.dataQueue.receivePoints(waitTimeLimit);
                if (points == null && !readyClose) {
                    continue;
                }
            }
            catch (InterruptedException itex) {
                readyClose = true;
                LOGGER.info("The thread {} is interrupted. cause {}", (Object)Thread.currentThread().getName(), (Object)itex.getMessage());
                break;
            }
            if (this.rateLimiter != null) {
                this.rateLimiter.acquire();
            }
            String strJson = points.toJSON();
            this.sendHttpRequest(points, strJson);
        }
        if (readyClose) {
            this.countDownLatch.countDown();
        }
    }

    private void sendHttpRequest(PointsCollection points, String strJson) {
        if (points.isEmpty()) {
            LOGGER.warn("PointsCollection is empty, nothing to post");
        }
        String address = this.getAddressAndSemaphoreAcquire();
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        if (points.getSimplePointBatchCallbak() != null) {
            AbstractBatchPutCallback scallback = points.getSimplePointBatchCallbak();
            if (scallback != null && !(scallback instanceof BatchPutCallback)) {
                if (scallback instanceof BatchPutSummaryCallback) {
                    paramsMap.put("summary", "true");
                } else if (scallback instanceof BatchPutDetailsCallback) {
                    paramsMap.put("details", "true");
                }
            }
            List<Point> slist = points.asSingleFieldPoints();
            FutureCallback<HttpResponse> postHttpCallback = this.httpResponseCallbackFactory.createBatchPutDataCallback(address, scallback, slist, this.config, this.config.getBatchPutRetryCount());
            try {
                this.tsdbHttpClient.postToAddress(address, "/api/put", strJson, paramsMap, postHttpCallback);
            }
            catch (Exception ex) {
                this.semaphoreManager.release(address);
                scallback.failed(address, slist, ex);
            }
        } else {
            AbstractMultiFieldBatchPutCallback mcallback = points.getMultiFieldBatchPutCallback();
            if (mcallback != null) {
                if (!(mcallback instanceof MultiFieldBatchPutCallback)) {
                    if (mcallback instanceof MultiFieldBatchPutSummaryCallback) {
                        paramsMap.put("summary", "true");
                    } else if (mcallback instanceof MultiFieldBatchPutDetailsCallback) {
                        paramsMap.put("details", "true");
                    }
                }
                List<MultiFieldPoint> mlist = points.asMultiFieldPoints();
                FutureCallback<HttpResponse> postHttpCallback = this.httpResponseCallbackFactory.createMultiFieldBatchPutDataCallback(address, mcallback, mlist, this.config, this.config.getBatchPutRetryCount());
                try {
                    this.tsdbHttpClient.postToAddress(address, "/api/mput", strJson, paramsMap, postHttpCallback);
                }
                catch (Exception ex) {
                    this.semaphoreManager.release(address);
                    mcallback.failed(address, mlist, ex);
                }
            } else {
                LOGGER.warn("No batch callback at all");
            }
        }
    }
}

