/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.queue;

import com.aliyun.hitsdb.client.exception.BufferQueueFullException;
import com.aliyun.hitsdb.client.queue.DataQueue;
import com.aliyun.hitsdb.client.value.request.MultiFieldPoint;
import com.aliyun.hitsdb.client.value.request.Point;
import com.aliyun.hitsdb.client.value.request.PointsCollection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPointQueue
implements DataQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataPointQueue.class);
    private final BlockingQueue<Point> pointQueue;
    private final BlockingQueue<MultiFieldPoint> multiFieldPointQueue;
    private final BlockingQueue<PointsCollection> pointsCollectionQueue;
    private final AtomicBoolean forbiddenWrite = new AtomicBoolean(false);
    private final int waitCloseTimeLimit;
    private final boolean backpressure;

    public DataPointQueue(int batchPutBufferSize, int multiFieldBatchPutBufferSize, int waitCloseTimeLimit, boolean backpressure) {
        if (batchPutBufferSize <= 0) {
            batchPutBufferSize = 1;
        }
        if (multiFieldBatchPutBufferSize <= 0) {
            multiFieldBatchPutBufferSize = 1;
        }
        this.pointQueue = new ArrayBlockingQueue<Point>(batchPutBufferSize);
        this.multiFieldPointQueue = new ArrayBlockingQueue<MultiFieldPoint>(multiFieldBatchPutBufferSize);
        this.pointsCollectionQueue = new ArrayBlockingQueue<PointsCollection>(Math.max(batchPutBufferSize, multiFieldBatchPutBufferSize));
        this.waitCloseTimeLimit = waitCloseTimeLimit;
        this.backpressure = backpressure;
    }

    @Override
    public void send(Point point) {
        this.verifyWrite();
        if (this.backpressure) {
            try {
                this.pointQueue.put(point);
            }
            catch (InterruptedException e) {
                LOGGER.error("Client Thread been Interrupted.", (Throwable)e);
            }
        } else {
            try {
                this.pointQueue.add(point);
            }
            catch (IllegalStateException exception) {
                throw new BufferQueueFullException("The buffer queue is full.", exception);
            }
        }
    }

    private void verifyWrite() {
        if (this.forbiddenWrite.get()) {
            throw new IllegalStateException("client has been closed.");
        }
    }

    @Override
    public Point receive() throws InterruptedException {
        return this.pointQueue.take();
    }

    @Override
    public Point receive(int timeout) throws InterruptedException {
        return this.pointQueue.poll(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void sendMultiFieldPoint(MultiFieldPoint point) {
        this.verifyWrite();
        if (this.backpressure) {
            try {
                this.multiFieldPointQueue.put(point);
            }
            catch (InterruptedException e) {
                LOGGER.error("Client Thread been Interrupted.", (Throwable)e);
            }
        } else {
            try {
                this.multiFieldPointQueue.add(point);
            }
            catch (IllegalStateException exception) {
                throw new BufferQueueFullException("The buffer queue is full.", exception);
            }
        }
    }

    @Override
    public MultiFieldPoint receiveMultiFieldPoint() throws InterruptedException {
        return this.multiFieldPointQueue.take();
    }

    @Override
    public MultiFieldPoint receiveMultiFieldPoint(int timeout) throws InterruptedException {
        return this.multiFieldPointQueue.poll(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void sendPoints(PointsCollection points) {
        this.verifyWrite();
        if (this.backpressure) {
            try {
                this.pointsCollectionQueue.put(points);
            }
            catch (InterruptedException e) {
                LOGGER.error("Client Thread been Interrupted.", (Throwable)e);
            }
        } else {
            try {
                this.pointsCollectionQueue.add(points);
            }
            catch (IllegalStateException exception) {
                throw new BufferQueueFullException("The buffer queue is full.", exception);
            }
        }
    }

    @Override
    public PointsCollection receivePoints() throws InterruptedException {
        return this.pointsCollectionQueue.take();
    }

    @Override
    public PointsCollection receivePoints(int timeout) throws InterruptedException {
        return this.pointsCollectionQueue.poll(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void forbiddenSend() {
        this.forbiddenWrite.compareAndSet(false, true);
    }

    @Override
    public void waitEmpty() {
        if (this.forbiddenWrite.get()) {
            try {
                Thread.sleep(this.waitCloseTimeLimit);
            }
            catch (InterruptedException e) {
                LOGGER.warn("The method waitEmpty() is being illegally interrupted");
            }
            while (true) {
                boolean empty = this.pointQueue.isEmpty();
                boolean multiEmpty = this.multiFieldPointQueue.isEmpty();
                boolean asyncQueueEmpty = this.pointsCollectionQueue.isEmpty();
                if (empty && multiEmpty && asyncQueueEmpty) {
                    return;
                }
                try {
                    Thread.sleep(this.waitCloseTimeLimit);
                }
                catch (InterruptedException e) {
                    LOGGER.warn("The waitEmpty() method is being illegally interrupted");
                }
            }
        }
        throw new IllegalStateException("The queue is still allowed to write data. you must first call the forbiddenSend() method");
    }

    @Override
    public boolean isEmpty() {
        return this.pointQueue.isEmpty() && this.multiFieldPointQueue.isEmpty() && this.pointsCollectionQueue.isEmpty();
    }

    @Override
    public Point[] getPoints() {
        return this.pointQueue.toArray(new Point[0]);
    }
}

