/*
 * Copyright Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.aliyun.lindorm.pool;

import com.alibaba.druid.pool.DruidDataSource;

import javax.sql.DataSource;

/**
 * 将Druid连接池包装在内部，并设置默认最佳实践初始化参数
 *
 * @author jianhong.hjh
 */
public class LindormDataSource extends DruidDataSource implements DataSource {

  public LindormDataSource() {
    // 获取连接最大等待时间, 单位毫秒
    this.setMaxWait(30000);

    // 添加默认保活参数避免出现ConnectionDisconnectedException
    // 服务端默认idle时间是10分钟

    this.setTimeBetweenEvictionRunsMillis(5000);
    this.setMinEvictableIdleTimeMillis(600000);
    this.setMaxEvictableIdleTimeMillis(900000);
    this.setKeepAliveBetweenTimeMillis(30000);
    this.setKeepAlive(true);

    // 连接验证配置项
    this.setValidationQuery("SELECT 1");
    this.setTestWhileIdle(true);
    this.setTestOnBorrow(false);
    this.setTestOnReturn(false);

    // PreparedStatement缓存配置项，这里配置为关闭缓存
    // 避免运行时出现潜在的NoSuchStatement异常
    this.setPoolPreparedStatements(false);
    this.setMaxOpenPreparedStatements(-1);
    this.setMaxPoolPreparedStatementPerConnectionSize(-1);
  }
}
