/*
 * Copyright Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.aliyun.lindorm.table.blob;

import org.apache.http.client.methods.CloseableHttpResponse;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class LindormBlob implements Blob, Closeable {
  private final InputStream inputStream;
  private final long length;
  private final CloseableHttpResponse response;

  private static final String BLOB_LENGTH_HEADER = "Blob-Length";

  public LindormBlob(CloseableHttpResponse response) {
    this.response = response;
    this.length = Long.parseLong(response.getFirstHeader(BLOB_LENGTH_HEADER).getValue());
    try {
      this.inputStream = response.getEntity().getContent();
    } catch (IOException e) {
      throw new RuntimeException("blob get inputStream", e);
    }
  }

  @Override public long length() throws SQLException {
    return length;
  }

  @Override public InputStream getBinaryStream() throws SQLException {
    return inputStream;
  }

  @Override public void free() {
    try {
      inputStream.close();
    } catch (IOException e) {
      //ignore
    }
    try {
      response.close();
    } catch (IOException e) {
      //ignore
    }
  }

  @Override public byte[] getBytes(long pos, int length) throws SQLException {
    throw new UnsupportedOperationException();
  }

  @Override public long position(byte[] pattern, long start) throws SQLException {
    throw new UnsupportedOperationException();
  }

  @Override public long position(Blob pattern, long start) throws SQLException {
    throw new UnsupportedOperationException();
  }

  @Override public int setBytes(long pos, byte[] bytes) throws SQLException {
    throw new UnsupportedOperationException();
  }

  @Override public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
    throw new UnsupportedOperationException();
  }

  @Override public OutputStream setBinaryStream(long pos) throws SQLException {
    throw new UnsupportedOperationException();
  }

  @Override public void truncate(long len) throws SQLException {
    throw new UnsupportedOperationException();
  }

  @Override public InputStream getBinaryStream(long pos, long length) throws SQLException {
    throw new UnsupportedOperationException();
  }

  @Override public void close() {
    this.free();
  }
}
