/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mq.http.model.serialize;

import com.aliyun.mq.http.common.ClientException;
import com.aliyun.mq.http.model.Message;
import com.aliyun.mq.http.model.serialize.XMLDeserializer;
import com.aliyun.mq.http.model.serialize.XmlUtil;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MessageListDeserializer
extends XMLDeserializer<List<Message>> {
    @Override
    public List<Message> deserialize(InputStream stream) throws Exception {
        Document doc = this.getDocmentBuilder().parse(stream);
        return this.deserialize(doc);
    }

    public List<Message> deserialize(Document doc) {
        NodeList list = doc.getElementsByTagName("Message");
        if (list != null && list.getLength() > 0) {
            ArrayList<Message> results = new ArrayList<Message>();
            for (int i = 0; i < list.getLength(); ++i) {
                Message msg = this.parseMessage((Element)list.item(i));
                results.add(msg);
            }
            return results;
        }
        return null;
    }

    private Message parseMessage(Element root) throws ClientException {
        String consumedTimes;
        String firstConsumeTime;
        String nextConsumeTime;
        Message message = new Message();
        String messageId = this.safeGetElementContent(root, "MessageId", null);
        if (messageId == null) {
            message.setErrorMessage(this.parseErrorMessageResult(root));
            return message;
        }
        message.setMessageId(messageId);
        String messageBody = this.safeGetElementContent(root, "MessageBody", null);
        if (messageBody != null) {
            try {
                message.setMessageBody(messageBody);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Not support enconding:UTF-8");
            }
        }
        String messageBodyMD5 = this.safeGetElementContent(root, "MessageBodyMD5", null);
        message.setMessageBodyMD5(messageBodyMD5);
        String receiptHandle = this.safeGetElementContent(root, "ReceiptHandle", null);
        message.setReceiptHandle(receiptHandle);
        String publishTime = this.safeGetElementContent(root, "PublishTime", null);
        if (publishTime != null) {
            message.setPublishTime(Long.parseLong(publishTime));
        }
        if ((nextConsumeTime = this.safeGetElementContent(root, "NextConsumeTime", null)) != null) {
            message.setNextConsumeTime(Long.parseLong(nextConsumeTime));
        }
        if ((firstConsumeTime = this.safeGetElementContent(root, "FirstConsumeTime", null)) != null) {
            message.setFirstConsumeTime(Long.parseLong(firstConsumeTime));
        }
        if ((consumedTimes = this.safeGetElementContent(root, "ConsumedTimes", null)) != null) {
            message.setConsumedTimes(Integer.parseInt(consumedTimes));
        }
        message.setMessageTag(this.safeGetElementContent(root, "MessageTag", null));
        String properties = this.safeGetElementContent(root, "Properties", null);
        if (properties != null) {
            message.setProperties(XmlUtil.stringTopMap(properties));
        }
        return message;
    }
}

