/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils.transformer.to.jdbc;

import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.AbstractToJdbcDateTypeTransformer;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ToJdbcDateTransformer
extends AbstractToJdbcDateTypeTransformer {
    /*
     * Loose catch block
     */
    @Override
    public Object transform(Object o, String charset, Calendar cal, TimeZone timeZone) throws SQLException {
        if (o == null) {
            return null;
        }
        if (Date.class.isInstance(o)) {
            long time = ((Date)o).getTime();
            if (timeZone != null) {
                time += (long)timeZone.getOffset(time);
            }
            return new java.sql.Date(time);
        }
        if (o instanceof LocalDate) {
            LocalDate localDate = (LocalDate)o;
            Calendar calendar = (Calendar)((Calendar)DEFAULT_CALENDAR.get()).clone();
            calendar.clear();
            calendar.set(localDate.getYear(), localDate.getMonth().getValue() - 1, localDate.getDayOfMonth());
            return new java.sql.Date(calendar.getTime().getTime());
        }
        if (o instanceof byte[]) {
            try {
                SimpleDateFormat datetimeFormat = (SimpleDateFormat)DATETIME_FORMAT.get();
                SimpleDateFormat dateFormat = (SimpleDateFormat)DATE_FORMAT.get();
                if (cal != null) {
                    datetimeFormat.setCalendar(cal);
                    dateFormat.setCalendar(cal);
                }
                try {
                    java.sql.Date date = new java.sql.Date(datetimeFormat.parse(ToJdbcDateTransformer.encodeBytes((byte[])o, charset)).getTime());
                    return date;
                }
                catch (ParseException parseException) {
                    java.sql.Date date = new java.sql.Date(dateFormat.parse(ToJdbcDateTransformer.encodeBytes((byte[])o, charset)).getTime());
                    this.restoreToDefaultCalendar();
                    return date;
                    {
                        catch (ParseException parseException2) {
                            String errorMsg = ToJdbcDateTransformer.getTransformationErrMsg(ToJdbcDateTransformer.encodeBytes((byte[])o, charset), java.sql.Date.class);
                            throw new SQLException(errorMsg);
                        }
                    }
                }
            }
            finally {
                this.restoreToDefaultCalendar();
            }
        }
        String errorMsg = ToJdbcDateTransformer.getInvalidTransformationErrorMsg(o.getClass(), java.sql.Date.class);
        throw new SQLException(errorMsg);
    }
}

