/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils.transformer.to.jdbc;

import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.AbstractToJdbcTransformer;
import java.sql.SQLException;

public class ToJdbcDoubleTransformer
extends AbstractToJdbcTransformer {
    @Override
    public Object transform(Object o, String charset) throws SQLException {
        if (o == null) {
            return 0.0;
        }
        if (Number.class.isInstance(o)) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof byte[]) {
            try {
                return Double.parseDouble(ToJdbcDoubleTransformer.encodeBytes((byte[])o, charset));
            }
            catch (NumberFormatException e) {
                String errorMsg = ToJdbcDoubleTransformer.getTransformationErrMsg(ToJdbcDoubleTransformer.encodeBytes((byte[])o, charset), Double.TYPE);
                throw new SQLException(errorMsg);
            }
        }
        String errorMsg = ToJdbcDoubleTransformer.getInvalidTransformationErrorMsg(o.getClass(), Double.TYPE);
        throw new SQLException(errorMsg);
    }
}

