/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils.transformer.to.jdbc;

import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.AbstractToJdbcTransformer;
import java.sql.SQLException;

public class ToJdbcFloatTransformer
extends AbstractToJdbcTransformer {
    @Override
    public Object transform(Object o, String charset) throws SQLException {
        if (o == null) {
            return Float.valueOf(0.0f);
        }
        if (Number.class.isInstance(o)) {
            return Float.valueOf(((Number)o).floatValue());
        }
        if (o instanceof byte[]) {
            try {
                return Float.valueOf(Float.parseFloat(ToJdbcFloatTransformer.encodeBytes((byte[])o, charset)));
            }
            catch (NumberFormatException e) {
                String errorMsg = ToJdbcFloatTransformer.getTransformationErrMsg(ToJdbcFloatTransformer.encodeBytes((byte[])o, charset), Float.TYPE);
                throw new SQLException(errorMsg);
            }
        }
        String errorMsg = ToJdbcFloatTransformer.getInvalidTransformationErrorMsg(o.getClass(), Float.TYPE);
        throw new SQLException(errorMsg);
    }
}

