/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils.transformer.to.jdbc;

import com.aliyun.odps.data.SimpleStruct;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.AbstractToJdbcDateTypeTransformer;
import com.aliyun.odps.type.TypeInfo;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializer;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.TimeZone;

public class ToJdbcStringTransformer
extends AbstractToJdbcDateTypeTransformer {
    private static final String ZEROS = "000000000";
    static ThreadLocal<Gson> GSON_FORMAT = ThreadLocal.withInitial(() -> {
        JsonSerializer dateTimeSerializer = (date, type, jsonSerializationContext) -> {
            if (date == null) {
                return null;
            }
            return new JsonPrimitive(((SimpleDateFormat)DATETIME_FORMAT.get()).format((Date)date));
        };
        JsonSerializer timestampSerializer = (timestamp, type, jsonSerializationContext) -> {
            if (timestamp == null) {
                return null;
            }
            return new JsonPrimitive(ToJdbcStringTransformer.formatTimestamp(timestamp));
        };
        JsonSerializer structSerializer = (struct, type, jsonSerializationContext) -> {
            if (struct == null) {
                return null;
            }
            return ToJdbcStringTransformer.normalizeStruct(struct);
        };
        return new GsonBuilder().registerTypeAdapter(Date.class, (Object)dateTimeSerializer).registerTypeAdapter(Timestamp.class, (Object)timestampSerializer).registerTypeAdapter(SimpleStruct.class, (Object)structSerializer).serializeNulls().create();
    });

    private static String formatTimestamp(Timestamp value) {
        if (value.getNanos() == 0) {
            return ((SimpleDateFormat)DATETIME_FORMAT.get()).format(value);
        }
        String nanosValueStr = Integer.toString(value.getNanos());
        nanosValueStr = ZEROS.substring(0, 9 - nanosValueStr.length()) + nanosValueStr;
        char[] nanosChar = new char[nanosValueStr.length()];
        nanosValueStr.getChars(0, nanosValueStr.length(), nanosChar, 0);
        int truncIndex = 8;
        while (nanosChar[truncIndex] == '0') {
            --truncIndex;
        }
        nanosValueStr = new String(nanosChar, 0, truncIndex + 1);
        return String.format("%s.%s", ((SimpleDateFormat)DATETIME_FORMAT.get()).format(value), nanosValueStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object transform(Object o, String charset, Calendar cal, TimeZone timeZone, TypeInfo odpsType) throws SQLException {
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            return ToJdbcStringTransformer.encodeBytes((byte[])o, charset);
        }
        try {
            if (Date.class.isInstance(o)) {
                Calendar.Builder calendarBuilder = new Calendar.Builder().setCalendarType("iso8601").setLenient(true);
                if (timeZone != null) {
                    calendarBuilder.setTimeZone(timeZone);
                }
                Calendar calendar = calendarBuilder.build();
                if (Timestamp.class.isInstance(o)) {
                    ((SimpleDateFormat)DATETIME_FORMAT.get()).setCalendar(calendar);
                    String string = ToJdbcStringTransformer.formatTimestamp((Timestamp)o);
                    return string;
                }
                if (java.sql.Date.class.isInstance(o)) {
                    ((SimpleDateFormat)DATE_FORMAT.get()).setCalendar(calendar);
                    String string = ((SimpleDateFormat)DATE_FORMAT.get()).format(o);
                    return string;
                }
                ((SimpleDateFormat)DATETIME_FORMAT.get()).setCalendar(calendar);
                String string = ((SimpleDateFormat)DATETIME_FORMAT.get()).format(o);
                return string;
            }
            if (odpsType != null) {
                Calendar.Builder calendarBuilder = new Calendar.Builder().setCalendarType("iso8601").setLenient(true);
                if (timeZone != null) {
                    calendarBuilder.setTimeZone(timeZone);
                }
                Calendar calendar = calendarBuilder.build();
                ((SimpleDateFormat)DATETIME_FORMAT.get()).setCalendar(calendar);
                switch (odpsType.getOdpsType()) {
                    case ARRAY: 
                    case MAP: {
                        String string = GSON_FORMAT.get().toJson(o);
                        return string;
                    }
                    case STRUCT: {
                        String string = GSON_FORMAT.get().toJson(ToJdbcStringTransformer.normalizeStruct(o));
                        return string;
                    }
                }
                String string = o.toString();
                return string;
            }
            String string = o.toString();
            return string;
        }
        finally {
            this.restoreToDefaultCalendar();
        }
    }

    @Override
    public Object transform(Object o, String charset, Calendar cal, TimeZone timeZone) throws SQLException {
        return this.transform(o, charset, cal, timeZone, null);
    }

    private static JsonElement normalizeStruct(Object object) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        Struct struct = (Struct)object;
        for (int i = 0; i < struct.getFieldCount(); ++i) {
            values.put(struct.getFieldName(i), struct.getFieldValue(i));
        }
        return new Gson().toJsonTree(values);
    }
}

