/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.jdbc.OdpsResultSet;
import com.aliyun.odps.jdbc.OdpsResultSetMetaData;
import com.aliyun.odps.jdbc.OdpsStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class OdpsSessionForwardResultSet
extends OdpsResultSet
implements ResultSet {
    private Object[] currentRow;
    com.aliyun.odps.data.ResultSet resultSet;
    private int fetchedRows = 0;
    private int totalRows = Integer.MAX_VALUE;
    private boolean isClosed = false;
    private long startTime;

    OdpsSessionForwardResultSet(OdpsStatement stmt, OdpsResultSetMetaData meta, com.aliyun.odps.data.ResultSet resultSet, long startTime) throws SQLException {
        super(stmt.getConnection(), stmt, meta);
        if (stmt.resultSetMaxRows > 0) {
            this.totalRows = stmt.resultSetMaxRows;
        }
        this.resultSet = resultSet;
        this.startTime = startTime;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("The result set has been closed");
        }
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        return this.fetchedRows;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.conn.log.debug("the result set has been closed");
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.fetchedRows == this.totalRows || !this.resultSet.hasNext()) {
            this.conn.log.info("It took me " + (System.currentTimeMillis() - this.startTime) + " ms to fetch all records, count:" + this.fetchedRows);
            return false;
        }
        Record record = this.resultSet.next();
        int columns = record.getColumnCount();
        this.currentRow = new Object[columns];
        for (int i = 0; i < columns; ++i) {
            this.currentRow[i] = record.get(i);
        }
        ++this.fetchedRows;
        return true;
    }

    @Override
    protected Object[] rowAtCursor() throws SQLException {
        if (this.currentRow == null) {
            throw new SQLException("the row should be not-null, row=" + this.fetchedRows);
        }
        if (this.currentRow.length == 0) {
            throw new SQLException("the row should have more than 1 column , row=" + this.fetchedRows);
        }
        return this.currentRow;
    }
}

