/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc;

import com.aliyun.odps.Column;
import com.aliyun.odps.Instance;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.ResultSet;
import com.aliyun.odps.jdbc.OdpsConnection;
import com.aliyun.odps.jdbc.OdpsResultSetMetaData;
import com.aliyun.odps.jdbc.OdpsScollResultSet;
import com.aliyun.odps.jdbc.OdpsSessionForwardResultSet;
import com.aliyun.odps.jdbc.OdpsStaticResultSet;
import com.aliyun.odps.jdbc.WrapperAdapter;
import com.aliyun.odps.jdbc.utils.OdpsLogger;
import com.aliyun.odps.jdbc.utils.Utils;
import com.aliyun.odps.sqa.SQLExecutor;
import com.aliyun.odps.tunnel.InstanceTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import com.aliyun.odps.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;

public class OdpsStatement
extends WrapperAdapter
implements Statement {
    private OdpsConnection connHandle;
    private Instance executeInstance = null;
    private java.sql.ResultSet resultSet = null;
    private int updateCount = -1;
    private int queryTimeout = -1;
    ResultSet odpsResultSet = null;
    private String logviewUrl = null;
    boolean updateCountFetched = false;
    private boolean isClosed = false;
    private boolean isCancelled = false;
    private static final int POLLING_INTERVAL = 3000;
    private static final String JDBC_SQL_TASK_NAME = "jdbc_sql_task";
    private static final String JDBC_SQL_OFFLINE_TASK_NAME = "sqlrt_fallback_task";
    private static java.sql.ResultSet EMPTY_RESULT_SET = null;
    protected boolean isResultSetScrollable = false;
    private Properties sqlTaskProperties;
    private Properties inputProperties;
    protected FetchDirection resultSetFetchDirection = FetchDirection.UNKNOWN;
    protected int resultSetMaxRows = 0;
    protected int resultSetFetchSize = 10000;
    protected Long resultCountLimit = null;
    protected Long resultSizeLimit = null;
    protected boolean enableLimit = false;
    private SQLWarning warningChain = null;

    OdpsStatement(OdpsConnection conn) {
        this(conn, false);
    }

    OdpsStatement(OdpsConnection conn, boolean isResultSetScrollable) {
        this.connHandle = conn;
        this.sqlTaskProperties = (Properties)conn.getSqlTaskProperties().clone();
        this.resultCountLimit = conn.getCountLimit();
        this.resultSizeLimit = conn.getSizeLimit();
        this.enableLimit = conn.enableLimit();
        this.isResultSetScrollable = isResultSetScrollable;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        if (this.isCancelled || this.executeInstance == null) {
            return;
        }
        try {
            if (this.connHandle.runningInInteractiveMode()) {
                this.connHandle.getExecutor().cancel();
                this.connHandle.log.info("submit cancel query instance id=" + this.executeInstance.getId());
            } else if (!this.executeInstance.isTerminated()) {
                this.executeInstance.stop();
                this.connHandle.log.info("submit cancel to instance id=" + this.executeInstance.getId());
            }
        }
        catch (OdpsException e) {
            throw new SQLException(e);
        }
        this.isCancelled = true;
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.connHandle.log.info("the statement has been closed");
        this.connHandle = null;
        this.executeInstance = null;
        this.odpsResultSet = null;
        this.isClosed = true;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public synchronized java.sql.ResultSet executeQuery(String sql) throws SQLException {
        Properties properties = new Properties();
        String query = Utils.parseSetting(sql, properties);
        if (StringUtils.isNullOrEmpty((String)query)) {
            this.processSetClause(properties);
            return EMPTY_RESULT_SET;
        }
        if (this.processUseClause(query)) {
            return EMPTY_RESULT_SET;
        }
        this.checkClosed();
        this.beforeExecute();
        this.runSQL(query, properties, false);
        return this.hasResultSet() ? this.getResultSet() : EMPTY_RESULT_SET;
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        Properties properties = new Properties();
        String query = Utils.parseSetting(sql, properties);
        if (StringUtils.isNullOrEmpty((String)query)) {
            this.processSetClause(properties);
            return 0;
        }
        this.checkClosed();
        this.beforeExecute();
        this.runSQL(query, properties, true);
        return this.updateCount >= 0 ? this.updateCount : 0;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        Properties properties = new Properties();
        String query = Utils.parseSetting(sql, properties);
        if (StringUtils.isNullOrEmpty((String)query)) {
            this.processSetClause(properties);
            return false;
        }
        if (this.processUseClause(query)) {
            return false;
        }
        this.checkClosed();
        this.beforeExecute();
        this.runSQL(query, properties);
        return this.hasResultSet();
    }

    private boolean hasResultSet() {
        if (this.connHandle.getExecutor() == null) {
            return false;
        }
        if (this.odpsResultSet != null) {
            return true;
        }
        return this.connHandle.getExecutor().hasResultSet();
    }

    @Deprecated
    public boolean hasResultSet(String sql) throws SQLException {
        if (this.connHandle.runningInInteractiveMode()) {
            return true;
        }
        if (this.updateCount == 0) {
            return OdpsStatement.isQuery(sql);
        }
        return this.updateCount < 0;
    }

    public static boolean isQuery(String sql) throws SQLException {
        BufferedReader reader = new BufferedReader(new StringReader(sql));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.matches("^\\s*(--|#).*") || line.matches("^\\s*$")) continue;
                if (!line.matches("(?i)^(\\s*)(SELECT).*$")) break;
                return true;
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return false;
    }

    private void processSetClause(Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            this.connHandle.log.info("set sql task property: " + key + "=" + properties.getProperty(key));
            if (!this.connHandle.disableConnSetting()) {
                this.connHandle.getSqlTaskProperties().setProperty(key, properties.getProperty(key));
            }
            this.sqlTaskProperties.setProperty(key, properties.getProperty(key));
        }
    }

    private boolean processUseClause(String sql) throws SQLFeatureNotSupportedException {
        if (sql.matches("(?i)^(\\s*)(USE)(\\s+)(.*);?(\\s*)$")) {
            int i;
            String project;
            if (sql.contains(";")) {
                sql = sql.replace(';', ' ');
            }
            if ((project = sql.substring((i = sql.toLowerCase().indexOf("use")) + 3).trim()).length() > 0) {
                if (this.connHandle.runningInInteractiveMode()) {
                    throw new SQLFeatureNotSupportedException("ODPS-1850001 - 'use project' is not supported in odps jdbc for now.");
                }
                this.connHandle.getOdps().setDefaultProject(project);
                this.connHandle.log.info("set project to " + project);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public OdpsConnection getConnection() throws SQLException {
        return this.connHandle;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        int direction;
        this.checkClosed();
        switch (this.resultSetFetchDirection) {
            case FORWARD: {
                direction = 1000;
                break;
            }
            case REVERSE: {
                direction = 1001;
                break;
            }
            default: {
                direction = 1002;
            }
        }
        return direction;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.resultSetFetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        this.resultSetFetchSize = rows;
    }

    @Override
    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.resultSetMaxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("max must be >= 0");
        }
        this.resultSetMaxRows = max;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (!this.connHandle.runningInInteractiveMode()) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds <= 0) {
            throw new IllegalArgumentException("Invalid query timeout:" + String.valueOf(seconds));
        }
        if (!this.connHandle.runningInInteractiveMode()) {
            this.connHandle.log.error("OdpsDriver do not support query timeout, setQueryTimeout: " + seconds);
        } else {
            this.queryTimeout = seconds;
        }
    }

    @Override
    public java.sql.ResultSet getResultSet() throws SQLException {
        long startTime = System.currentTimeMillis();
        if ((this.resultSet == null || this.resultSet.isClosed()) && this.odpsResultSet != null) {
            OdpsResultSetMetaData meta = this.getResultMeta(this.odpsResultSet.getTableSchema().getColumns());
            try {
                if (this.connHandle.getExecutor().getInstance() == null) {
                    this.resultSet = new OdpsSessionForwardResultSet(this, meta, this.odpsResultSet, startTime);
                } else {
                    InstanceTunnel tunnel = new InstanceTunnel(this.connHandle.getOdps());
                    String te = this.connHandle.getTunnelEndpoint();
                    if (!StringUtils.isNullOrEmpty((String)te)) {
                        this.connHandle.log.info("using tunnel endpoint: " + te);
                        tunnel.setEndpoint(te);
                    }
                    if (this.connHandle.getTunnelConnectTimeout() >= 0) {
                        tunnel.getConfig().setSocketConnectTimeout(this.connHandle.getTunnelConnectTimeout());
                    }
                    if (this.connHandle.getTunnelReadTimeout() >= 0) {
                        tunnel.getConfig().setSocketTimeout(this.connHandle.getTunnelReadTimeout());
                    }
                    InstanceTunnel.DownloadSession session = tunnel.createDirectDownloadSession(this.connHandle.getOdps().getDefaultProject(), this.connHandle.getExecutor().getInstance().getId(), this.connHandle.getExecutor().getTaskName(), this.connHandle.getExecutor().getSubqueryId(), this.enableLimit);
                    this.resultSet = this.isResultSetScrollable ? new OdpsScollResultSet(this, meta, session, this.connHandle.getExecutor().isRunningInInteractiveMode() ? OdpsScollResultSet.ResultMode.INTERACTIVE : OdpsScollResultSet.ResultMode.OFFLINE) : new OdpsSessionForwardResultSet(this, meta, this.odpsResultSet, startTime);
                }
                this.odpsResultSet = null;
            }
            catch (TunnelException e) {
                this.connHandle.log.error("create download session for session failed: " + e.getMessage());
                e.printStackTrace();
                throw new SQLException("create session resultset failed: instance id=" + this.connHandle.getExecutor().getInstance().getId() + ", Error:" + e.getMessage(), e);
            }
            catch (IOException e) {
                this.connHandle.log.error("create download session for session failed: " + e.getMessage());
                e.printStackTrace();
                throw new SQLException("create session resultset failed: instance id=" + this.connHandle.getExecutor().getInstance().getId() + ", Error:" + e.getMessage(), e);
            }
        }
        return this.resultSet;
    }

    private OdpsResultSetMetaData getResultMeta(List<Column> columns) {
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<TypeInfo> columnSqlTypes = new ArrayList<TypeInfo>();
        for (Column col : columns) {
            columnNames.add(col.getName());
            columnSqlTypes.add(col.getTypeInfo());
        }
        return new OdpsResultSetMetaData(columnNames, columnSqlTypes);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        this.checkClosed();
        if (this.updateCountFetched) {
            return -1;
        }
        this.updateCountFetched = true;
        if (this.executeInstance == null) {
            return -1;
        }
        return this.updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: {
                this.resultSetFetchDirection = FetchDirection.FORWARD;
                break;
            }
            case 1001: {
                this.resultSetFetchDirection = FetchDirection.REVERSE;
                break;
            }
            case 1002: {
                this.resultSetFetchDirection = FetchDirection.UNKNOWN;
                break;
            }
            default: {
                throw new SQLException("invalid argument for setFetchDirection()");
            }
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private void beforeExecute() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.executeInstance = null;
        this.odpsResultSet = null;
        this.isClosed = false;
        this.isCancelled = false;
        this.updateCount = -1;
        this.updateCountFetched = false;
    }

    protected OdpsLogger getParentLogger() {
        return this.connHandle.log;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("The statement has been closed");
        }
    }

    private void runSQL(String sql, Map<String, String> settings, boolean isUpdate) throws SQLException, OdpsException {
        Long autoSelectLimit;
        long begin = System.currentTimeMillis();
        SQLExecutor executor = this.connHandle.getExecutor();
        if (this.queryTimeout != -1 && !settings.containsKey("odps.sql.session.query.timeout")) {
            settings.put("odps.sql.session.query.timeout", String.valueOf(this.queryTimeout));
        }
        if ((autoSelectLimit = this.connHandle.getAutoSelectLimit()) != null && autoSelectLimit > 0L) {
            settings.put("odps.sql.select.auto.limit", autoSelectLimit.toString());
        }
        this.connHandle.log.info("Run SQL: " + sql + ", Begin time: " + begin);
        executor.run(sql, settings);
        this.executeInstance = executor.getInstance();
        if (this.executeInstance != null) {
            this.connHandle.log.info("InstanceId: " + this.executeInstance.getId());
        }
        this.logviewUrl = executor.getLogView();
        if (this.logviewUrl != null) {
            this.connHandle.log.info("LogView: " + this.logviewUrl);
        }
        if (isUpdate) {
            if (this.executeInstance != null) {
                this.executeInstance.waitForSuccess();
                Instance.TaskSummary taskSummary = null;
                try {
                    taskSummary = this.executeInstance.getTaskSummary(JDBC_SQL_OFFLINE_TASK_NAME);
                }
                catch (OdpsException e) {
                    this.connHandle.log.warn("Failed to get TaskSummary: instance_id=" + this.executeInstance.getId() + ", taskname=" + JDBC_SQL_OFFLINE_TASK_NAME);
                }
                if (taskSummary != null) {
                    this.updateCount = Utils.getSinkCountFromTaskSummary(StringEscapeUtils.unescapeJava((String)taskSummary.getJsonSummary()));
                    this.connHandle.log.debug("successfully updated " + this.updateCount + " records");
                } else {
                    this.connHandle.log.warn("task summary is empty");
                }
            }
            this.odpsResultSet = null;
        } else {
            try {
                this.setResultSetInternal();
                List exeLog = executor.getExecutionLog();
                if (!exeLog.isEmpty()) {
                    for (String log : exeLog) {
                        this.connHandle.log.warn("Session execution log:" + log);
                    }
                }
            }
            catch (IOException e) {
                this.connHandle.log.error("Run SQL failed", e);
                throw new SQLException("execute sql [" + sql + "] instance:[" + executor.getInstance().getId() + "] failed: " + e.getMessage(), e);
            }
            catch (OdpsException e) {
                this.connHandle.log.error("Run SQL failed", e);
                throw new SQLException("execute sql [" + sql + "] instance:[" + executor.getInstance().getId() + "] failed: " + e.getMessage(), e);
            }
        }
        long end = System.currentTimeMillis();
        if (this.executeInstance != null) {
            this.connHandle.log.info("It took me " + (end - begin) + " ms to run sql, instanceId: " + this.executeInstance.getId());
        } else {
            this.connHandle.log.info("It took me " + (end - begin) + " ms to run sql");
        }
        this.warningChain = new SQLWarning(executor.getSummary());
    }

    private void runSQL(String sql, Properties properties) throws SQLException {
        this.runSQL(sql, properties, false);
    }

    private void runSQL(String sql, Properties properties, boolean isUpdate) throws SQLException {
        try {
            if (!sql.endsWith(";")) {
                sql = sql + ";";
            }
            HashMap<String, String> settings = new HashMap<String, String>();
            for (String key : this.sqlTaskProperties.stringPropertyNames()) {
                settings.put(key, this.sqlTaskProperties.getProperty(key));
            }
            this.inputProperties = new Properties();
            if (properties != null && !properties.isEmpty()) {
                for (String key : properties.stringPropertyNames()) {
                    settings.put(key, properties.getProperty(key));
                    this.inputProperties.put(key, properties.getProperty(key));
                }
            }
            if (!settings.isEmpty()) {
                this.connHandle.log.info("Enabled SQL task properties: " + settings);
            }
            this.runSQL(sql, settings, isUpdate);
        }
        catch (OdpsException e) {
            this.connHandle.log.error("Fail to run sql: " + sql, e);
            throw new SQLException("Fail to run sql:" + sql + ", Error:" + e.toString(), e);
        }
    }

    public Instance getExecuteInstance() {
        return this.executeInstance;
    }

    public static String getDefaultTaskName() {
        return JDBC_SQL_TASK_NAME;
    }

    public Properties getSqlTaskProperties() {
        return this.sqlTaskProperties;
    }

    public Properties getInputProperties() {
        return this.inputProperties;
    }

    public String getLogViewUrl() {
        return this.logviewUrl;
    }

    private void setResultSetInternal() throws OdpsException, IOException {
        if (this.connHandle.isTunnelDownloadUseSingleReader()) {
            this.executeInstance.waitForSuccess();
            Instance instance = this.executeInstance;
            InstanceTunnel tunnel = new InstanceTunnel(this.connHandle.getOdps());
            InstanceTunnel.DownloadSession downloadSession = tunnel.createDownloadSession(instance.getProject(), instance.getId());
            this.odpsResultSet = new ResultSet((Iterator)new SingleReaderResultSetIterator(downloadSession, downloadSession.getRecordCount()), downloadSession.getSchema(), downloadSession.getRecordCount());
        } else {
            this.odpsResultSet = this.connHandle.getExecutor().getResultSet(Long.valueOf(0L), this.resultCountLimit, this.resultSizeLimit, this.enableLimit);
        }
    }

    static {
        try {
            OdpsResultSetMetaData meta = new OdpsResultSetMetaData(Collections.singletonList("N/A"), Collections.singletonList(TypeInfoFactory.STRING));
            EMPTY_RESULT_SET = new OdpsStaticResultSet(null, meta, null);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    class SingleReaderResultSetIterator
    implements Iterator<Record> {
        private final TunnelRecordReader reader;
        private final InstanceTunnel.DownloadSession session;
        private Record nextLine;

        public SingleReaderResultSetIterator(InstanceTunnel.DownloadSession session, long recordCount) {
            try {
                this.session = session;
                this.reader = session.openRecordReader(0L, recordCount);
                this.moveToNextLine();
            }
            catch (TunnelException | IOException e) {
                throw new RuntimeException("Open tunnel reader failed, session id: " + session.getId() + " errMsg: " + e.getMessage(), e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextLine != null;
        }

        @Override
        public Record next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Record currLine = this.nextLine;
            this.moveToNextLine();
            return currLine;
        }

        private void moveToNextLine() {
            try {
                this.nextLine = this.reader.read();
            }
            catch (IOException e) {
                this.nextLine = null;
                throw new RuntimeException("Read record failed, session id: " + this.session.getId() + " errMsg: " + e.getMessage(), e);
            }
        }
    }

    static enum FetchDirection {
        FORWARD,
        REVERSE,
        UNKNOWN;

    }
}

