/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.OdpsTypeTransformer;
import com.aliyun.odps.type.CharTypeInfo;
import com.aliyun.odps.type.DecimalTypeInfo;
import com.aliyun.odps.type.SimplePrimitiveTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.VarcharTypeInfo;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class JdbcColumn {
    public static final String ODPS_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSSSSSSSS";
    public static final String ODPS_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String ODPS_DATE_FORMAT = "yyyy-MM-dd";
    public static final String ODPS_TIME_FORMAT = "HH:mm:ss";
    public static final int ODPS_DECIMAL_PRECISON = 54;
    public static final int ODPS_DECIMAL_SCALE = 18;
    public static final int ODPS_STRING_CHARACTERS = 0x2AAAAA;
    private static Map<OdpsType, Integer> ODPS_SQLTYPE_MAPPER = new HashMap<OdpsType, Integer>();
    private final String columnName;
    private final String tableName;
    private final String tableSchema;
    private final OdpsType type;
    private final String comment;
    private final int ordinalPos;
    private final TypeInfo typeInfo;

    public JdbcColumn(String columnName, String tableName, String tableSchema, OdpsType type, TypeInfo typeInfo, String comment, int ordinalPos) {
        this.columnName = columnName;
        this.tableName = tableName;
        this.tableSchema = tableSchema;
        this.type = type;
        this.typeInfo = typeInfo;
        this.comment = comment;
        this.ordinalPos = ordinalPos;
    }

    public static int odpsTypeToSqlType(OdpsType type) throws SQLException {
        if (ODPS_SQLTYPE_MAPPER.containsKey(type)) {
            return ODPS_SQLTYPE_MAPPER.get(type);
        }
        throw new SQLException("Invalid odps type: " + type);
    }

    public static String columnClassName(OdpsType type) throws SQLException {
        return OdpsTypeTransformer.odpsTypeToJavaType((OdpsType)type).getName();
    }

    public static int columnDisplaySize(TypeInfo typeInfo) throws SQLException {
        int columnType = JdbcColumn.odpsTypeToSqlType(typeInfo.getOdpsType());
        switch (columnType) {
            case 0: {
                return 4;
            }
            case 16: {
                return JdbcColumn.columnPrecision(typeInfo);
            }
            case 1: 
            case 12: {
                return JdbcColumn.columnPrecision(typeInfo);
            }
            case -2: {
                return Integer.MAX_VALUE;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return JdbcColumn.columnPrecision(typeInfo) + 1;
            }
            case 91: {
                return 10;
            }
            case 93: {
                return JdbcColumn.columnPrecision(typeInfo);
            }
            case 6: {
                return 24;
            }
            case 8: {
                return 25;
            }
            case 3: {
                return JdbcColumn.columnPrecision(typeInfo) + 2;
            }
            case 1111: 
            case 2000: {
                return JdbcColumn.columnPrecision(typeInfo);
            }
            case 2002: 
            case 2003: {
                return Integer.MAX_VALUE;
            }
        }
        throw new SQLException("Invalid odps type: " + columnType);
    }

    public static int columnPrecision(TypeInfo typeInfo) throws SQLException {
        int columnType = JdbcColumn.odpsTypeToSqlType(typeInfo.getOdpsType());
        switch (columnType) {
            case 0: {
                return 0;
            }
            case 16: {
                return 1;
            }
            case 1: 
            case 12: {
                if (typeInfo instanceof VarcharTypeInfo) {
                    return ((VarcharTypeInfo)typeInfo).getLength();
                }
                if (typeInfo instanceof CharTypeInfo) {
                    return ((CharTypeInfo)typeInfo).getLength();
                }
                return Integer.MAX_VALUE;
            }
            case -2: {
                return Integer.MAX_VALUE;
            }
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case -5: {
                return 19;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 91: {
                return 10;
            }
            case 93: {
                return 29;
            }
            case 3: {
                return ((DecimalTypeInfo)typeInfo).getPrecision();
            }
            case 1111: 
            case 2000: {
                if (typeInfo instanceof SimplePrimitiveTypeInfo) {
                    SimplePrimitiveTypeInfo spti = (SimplePrimitiveTypeInfo)typeInfo;
                    if (OdpsType.INTERVAL_YEAR_MONTH.equals((Object)spti.getOdpsType())) {
                        return 11;
                    }
                    if (OdpsType.INTERVAL_DAY_TIME.equals((Object)spti.getOdpsType())) {
                        return 29;
                    }
                }
                return Integer.MAX_VALUE;
            }
            case 2002: 
            case 2003: {
                return Integer.MAX_VALUE;
            }
        }
        throw new SQLException("Invalid odps type: " + columnType);
    }

    public static int columnScale(OdpsType type, TypeInfo typeInfo) throws SQLException {
        int columnType = JdbcColumn.odpsTypeToSqlType(type);
        switch (columnType) {
            case -6: 
            case -5: 
            case -2: 
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 12: 
            case 16: 
            case 91: {
                return 0;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 93: {
                return 9;
            }
            case 3: {
                return ((DecimalTypeInfo)typeInfo).getScale();
            }
            case 1111: 
            case 2000: 
            case 2002: 
            case 2003: {
                return 0;
            }
        }
        throw new SQLException("Invalid odps type: " + columnType);
    }

    public static boolean columnCaseSensitive(OdpsType type) throws SQLException {
        int columnType = JdbcColumn.odpsTypeToSqlType(type);
        switch (columnType) {
            case -6: 
            case -5: 
            case -2: 
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 16: 
            case 91: 
            case 93: 
            case 1111: 
            case 2000: 
            case 2002: 
            case 2003: {
                return false;
            }
            case 1: 
            case 12: {
                return true;
            }
        }
        throw new SQLException("Invalid odps type: " + columnType);
    }

    public static boolean columnSigned(OdpsType type) throws SQLException {
        int columnType = JdbcColumn.odpsTypeToSqlType(type);
        switch (columnType) {
            case -2: 
            case 0: 
            case 1: 
            case 12: 
            case 16: 
            case 91: 
            case 93: 
            case 1111: 
            case 2000: 
            case 2002: 
            case 2003: {
                return false;
            }
            case -6: 
            case -5: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
        }
        throw new SQLException("unknown OdpsType");
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }

    public int getType() throws SQLException {
        return JdbcColumn.odpsTypeToSqlType(this.type);
    }

    public String getComment() {
        return this.comment;
    }

    public String getTypeName() {
        return this.typeInfo.getTypeName();
    }

    public int getOrdinalPos() {
        return this.ordinalPos;
    }

    public int getNumPercRaidx() {
        return 10;
    }

    public int getIsNullable() {
        return 1;
    }

    public String getIsNullableString() {
        switch (this.getIsNullable()) {
            case 0: {
                return "NO";
            }
            case 1: {
                return "YES";
            }
            case 2: {
                return null;
            }
        }
        return null;
    }

    public int getDecimalDigits() {
        return 0;
    }

    static {
        ODPS_SQLTYPE_MAPPER.put(OdpsType.VOID, 0);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.BIGINT, -5);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.STRING, 12);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.DATETIME, 93);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.DOUBLE, 8);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.BOOLEAN, 16);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.DECIMAL, 3);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.ARRAY, 2003);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.MAP, 2000);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.STRUCT, 2002);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.INT, 4);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.TINYINT, -6);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.SMALLINT, 5);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.DATE, 91);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.TIMESTAMP, 93);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.FLOAT, 6);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.CHAR, 1);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.BINARY, -2);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.VARCHAR, 12);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.INTERVAL_YEAR_MONTH, 1111);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.INTERVAL_DAY_TIME, 1111);
        ODPS_SQLTYPE_MAPPER.put(OdpsType.JSON, 12);
    }
}

