/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils.transformer.to.jdbc;

import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.AbstractToJdbcTransformer;
import com.aliyun.odps.type.TypeInfo;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.TimeZone;

public abstract class AbstractToJdbcDateTypeTransformer
extends AbstractToJdbcTransformer {
    static ThreadLocal<Calendar> DEFAULT_CALENDAR = ThreadLocal.withInitial(() -> new Calendar.Builder().setCalendarType("iso8601").setTimeZone(TimeZone.getTimeZone("GMT")).build());
    static ThreadLocal<SimpleDateFormat> TIMESTAMP_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSSS"));
    static ThreadLocal<SimpleDateFormat> DATETIME_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    static ThreadLocal<SimpleDateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd"));
    static ThreadLocal<SimpleDateFormat> TIME_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("HH:mm:ss"));
    static ThreadLocal<DateTimeFormatter> ZONED_DATETIME_FORMAT = ThreadLocal.withInitial(() -> DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault()));

    @Override
    public Object transform(Object o, String charset) throws SQLException {
        return this.transform(o, charset, null, null);
    }

    @Override
    public Object transform(Object o, String charset, TypeInfo odpsType) throws SQLException {
        return this.transform(o, charset, null, null, odpsType);
    }

    public abstract Object transform(Object var1, String var2, Calendar var3, TimeZone var4) throws SQLException;

    public Object transform(Object o, String charset, Calendar cal, TimeZone timeZone, TypeInfo odpsType) throws SQLException {
        return this.transform(o, charset, cal, timeZone);
    }

    void restoreToDefaultCalendar() {
        TIMESTAMP_FORMAT.get().setCalendar(Calendar.getInstance());
        DATETIME_FORMAT.get().setCalendar(Calendar.getInstance());
        DATE_FORMAT.get().setCalendar(Calendar.getInstance());
        TIME_FORMAT.get().setCalendar(Calendar.getInstance());
    }
}

