/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils.transformer.to.odps;

import com.aliyun.odps.jdbc.utils.transformer.to.odps.AbstractToOdpsTransformer;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;

public class ToOdpsTimeStampTransformer
extends AbstractToOdpsTransformer {
    @Override
    public Object transform(Object o, String charset) throws SQLException {
        if (o == null) {
            return null;
        }
        if (Timestamp.class.isInstance(o)) {
            return ((Timestamp)o).toInstant().atZone(ZoneId.systemDefault()).toInstant();
        }
        if (Instant.class.isInstance(o)) {
            return o;
        }
        String errorMsg = ToOdpsTimeStampTransformer.getInvalidTransformationErrorMsg(o.getClass(), Timestamp.class);
        throw new SQLException(errorMsg);
    }
}

