/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data;

import java.io.Serializable;

public abstract class AbstractChar<T extends AbstractChar>
implements Serializable {
    protected String value;

    AbstractChar(String value) {
        this.value = value == null ? null : this.enforceMaxLength(value, value.length());
    }

    AbstractChar(String value, int maxLength) {
        this.value = this.enforceMaxLength(value, maxLength);
    }

    private String enforceMaxLength(String val, int maxLength) {
        int valLength;
        if (val == null) {
            return null;
        }
        String value = val;
        if (maxLength > 0 && (valLength = val.codePointCount(0, val.length())) > maxLength) {
            value = val.substring(0, val.offsetByCodePoints(0, maxLength));
        }
        return value;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractChar that = (AbstractChar)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }

    public int length() {
        return this.value.length();
    }
}

