/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class PartitionSpec
implements Serializable {
    private static final String COMMA = ",";
    private static final String SLASH = "/";
    private Map<String, String> kv = new LinkedHashMap<String, String>();

    public PartitionSpec() {
    }

    public PartitionSpec(String spec) {
        this(spec, true);
    }

    public PartitionSpec(String spec, boolean trim) {
        String[] groups;
        if (spec == null) {
            throw new IllegalArgumentException("Argument 'spec' cannot be null");
        }
        for (String group : groups = spec.split("[,/]")) {
            if (group.isEmpty()) {
                throw new IllegalArgumentException(String.format("Invalid partition spec: empty group in '%s'", spec));
            }
            String[] splits = group.split("=", 2);
            if (splits.length != 2) {
                throw new IllegalArgumentException(String.format("Invalid partition spec: expected key=value in '%s'", group));
            }
            String k = trim ? splits[0].trim() : splits[0];
            String v = (trim ? splits[1].trim() : splits[1]).replace("'", "").replace("\"", "");
            if (k.isEmpty()) {
                throw new IllegalArgumentException(String.format("Invalid partition spec: empty key in group '%s'", group));
            }
            if (v.isEmpty()) {
                throw new IllegalArgumentException(String.format("Invalid partition spec: empty value for key '%s' in group '%s'", k, group));
            }
            this.set(k, v);
        }
    }

    public void set(String key, String value) {
        this.kv.put(key, value);
    }

    public String get(String key) {
        return this.kv.get(key);
    }

    public Set<String> keys() {
        return this.kv.keySet();
    }

    public boolean isEmpty() {
        return this.kv.isEmpty();
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean quote, boolean useSlashDelimiter) {
        String[] keys;
        String delimiter = useSlashDelimiter ? SLASH : COMMA;
        LinkedList<String> entries = new LinkedList<String>();
        for (String key : keys = this.keys().toArray(new String[0])) {
            StringBuilder entryBuilder = new StringBuilder();
            entryBuilder.append(key).append("=");
            if (quote) {
                entryBuilder.append("'").append(this.kv.get(key)).append("'");
            } else {
                entryBuilder.append(this.kv.get(key));
            }
            entries.add(entryBuilder.toString());
        }
        return String.join((CharSequence)delimiter, entries);
    }
}

