/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data;

import com.aliyun.odps.data.Struct;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.utils.StringUtils;
import java.util.List;
import java.util.Objects;

public class SimpleStruct
implements Struct {
    protected StructTypeInfo typeInfo;
    protected List<Object> values;

    public SimpleStruct(StructTypeInfo type, List<Object> values) {
        if (type == null || values == null || values.size() != type.getFieldCount()) {
            throw new IllegalArgumentException("Illegal arguments for StructObject.");
        }
        this.typeInfo = type;
        this.values = values;
    }

    @Override
    public int getFieldCount() {
        return this.values.size();
    }

    @Override
    public String getFieldName(int index) {
        return this.typeInfo.getFieldNames().get(index);
    }

    @Override
    public TypeInfo getFieldTypeInfo(int index) {
        return this.typeInfo.getFieldTypeInfos().get(index);
    }

    @Override
    public Object getFieldValue(int index) {
        return this.values.get(index);
    }

    @Override
    public TypeInfo getFieldTypeInfo(String fieldName) {
        for (int i = 0; i < this.typeInfo.getFieldCount(); ++i) {
            if (!this.typeInfo.getFieldNames().get(i).equalsIgnoreCase(fieldName)) continue;
            return this.typeInfo.getFieldTypeInfos().get(i);
        }
        return null;
    }

    @Override
    public Object getFieldValue(String fieldName) {
        for (int i = 0; i < this.typeInfo.getFieldCount(); ++i) {
            if (!this.typeInfo.getFieldNames().get(i).equalsIgnoreCase(fieldName)) continue;
            return this.values.get(i);
        }
        return null;
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    @Override
    public List<Object> getFieldValues() {
        return this.values;
    }

    @Override
    public String toString() {
        String valueStr = "{";
        int colCount = this.getFieldCount();
        for (int i = 0; i < colCount; ++i) {
            valueStr = valueStr + this.getFieldName(i) + ":" + this.getFieldValue(i);
            if (i == colCount - 1) continue;
            valueStr = valueStr + ", ";
        }
        valueStr = valueStr + "}";
        return valueStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleStruct that = (SimpleStruct)o;
        if (!StringUtils.equalsIgnoreCase(this.typeInfo.getFieldNames(), that.typeInfo.getFieldNames())) {
            return false;
        }
        return Objects.equals(this.getFieldValues(), that.getFieldValues());
    }

    public int hashCode() {
        return Objects.hash(StringUtils.toLowerCase(this.typeInfo.getFieldNames()), this.values);
    }
}

