/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DataFormat
implements Serializable {
    private Type type;
    private Version version;

    public DataFormat() {
        this(Type.UNKNOWN, Version.UNKNOWN);
    }

    public DataFormat(Type type, Version version) {
        this.type = type;
        this.version = version;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFormat that = (DataFormat)o;
        return Objects.equals((Object)this.type, (Object)that.type) && Objects.equals((Object)this.version, (Object)that.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.version});
    }

    public static enum Version {
        V5("V5"),
        UNKNOWN("UNKNOWN");

        private final String versionStr;
        private static final Map<String, Version> CODE_MAP;

        private Version(String versionStr) {
            this.versionStr = versionStr;
        }

        public String toString() {
            return this.versionStr;
        }

        public static Optional<Version> byCode(String code) {
            return Optional.ofNullable(CODE_MAP.get(code));
        }

        static {
            CODE_MAP = Arrays.stream(Version.values()).collect(Collectors.toMap(v -> v.versionStr, Function.identity()));
        }
    }

    public static enum Type {
        ARROW("ARROW"),
        RECORD("RECORD"),
        UNKNOWN("UNKNOWN");

        private final String typeStr;
        private static final Map<String, Type> TYPE_MAP;

        private Type(String typeStr) {
            this.typeStr = typeStr;
        }

        public String toString() {
            return this.typeStr;
        }

        public static Optional<Type> byTypeName(String type) {
            return Optional.ofNullable(TYPE_MAP.get(type));
        }

        static {
            TYPE_MAP = Arrays.stream(Type.values()).collect(Collectors.toMap(v -> v.typeStr, Function.identity()));
        }
    }
}

