/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.arrow.constructor;

import com.aliyun.odps.table.utils.Preconditions;
import org.apache.arrow.vector.ValueVector;

public abstract class ArrowFieldWriter<IN> {
    protected final ValueVector valueVector;
    protected int count = 0;

    public ArrowFieldWriter(ValueVector valueVector) {
        this.valueVector = (ValueVector)Preconditions.checkNotNull((Object)valueVector, (String)"Value vector");
    }

    public int getCount() {
        return this.count;
    }

    public String getName() {
        return this.valueVector.getField().getName();
    }

    public void write(IN row, int ordinal) {
        if (this.isNullAt(row, ordinal)) {
            this.setNull();
        } else {
            this.setValue(row, ordinal);
        }
        ++this.count;
    }

    public void finish() {
        this.valueVector.setValueCount(this.count);
    }

    public void reset() {
        this.valueVector.reset();
        this.count = 0;
    }

    protected abstract boolean isNullAt(IN var1, int var2);

    protected abstract void setValue(IN var1, int var2);

    protected abstract void setNull();
}

