/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.arrow.constructor;

import com.aliyun.odps.table.arrow.constructor.ArrowFieldWriter;
import com.google.common.base.Preconditions;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;

public abstract class ArrowMapWriter<IN, TYPE_MAP, TYPE_KEY_ARRAY, TYPE_VALUE_ARRAY>
extends ArrowFieldWriter<IN> {
    protected StructVector structVector;
    protected ArrowFieldWriter<TYPE_KEY_ARRAY> keyWriter;
    protected ArrowFieldWriter<TYPE_VALUE_ARRAY> valueWriter;

    public ArrowMapWriter(MapVector mapVector, ArrowFieldWriter<TYPE_KEY_ARRAY> keyWriter, ArrowFieldWriter<TYPE_VALUE_ARRAY> valueWriter) {
        super((ValueVector)mapVector);
        this.structVector = (StructVector)mapVector.getDataVector();
        this.keyWriter = (ArrowFieldWriter)Preconditions.checkNotNull(keyWriter);
        this.valueWriter = (ArrowFieldWriter)Preconditions.checkNotNull(valueWriter);
    }

    protected abstract TYPE_MAP readMap(IN var1, int var2);

    protected abstract TYPE_KEY_ARRAY readKeyArray(TYPE_MAP var1);

    protected abstract TYPE_VALUE_ARRAY readValueArray(TYPE_MAP var1);

    protected abstract int numElements(TYPE_MAP var1);

    @Override
    protected void setValue(IN in, int ordinal) {
        ((MapVector)this.valueVector).startNewValue(this.getCount());
        TYPE_MAP map = this.readMap(in, ordinal);
        TYPE_KEY_ARRAY keyArray = this.readKeyArray(map);
        TYPE_VALUE_ARRAY valueArray = this.readValueArray(map);
        int mapSize = this.numElements(map);
        for (int i = 0; i < mapSize; ++i) {
            this.structVector.setIndexDefined(this.keyWriter.getCount());
            this.keyWriter.write(keyArray, i);
            this.valueWriter.write(valueArray, i);
        }
        ((MapVector)this.valueVector).endValue(this.getCount(), mapSize);
    }

    @Override
    protected void setNull() {
    }

    @Override
    public void finish() {
        super.finish();
        this.keyWriter.finish();
        this.valueWriter.finish();
    }

    @Override
    public void reset() {
        super.reset();
        this.keyWriter.reset();
        this.valueWriter.reset();
    }
}

