/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.configuration;

import java.io.Serializable;

public class ArrowOptions
implements Serializable {
    public static final TimestampUnit DEFAULT_TIMESTAMP_UNIT = TimestampUnit.NANO;
    public static final TimestampUnit DEFAULT_DATETIME_UNIT = TimestampUnit.MILLI;
    private TimestampUnit timestampUnit = DEFAULT_TIMESTAMP_UNIT;
    private TimestampUnit dateTimeUnit = DEFAULT_DATETIME_UNIT;

    private ArrowOptions() {
    }

    public TimestampUnit getTimestampUnit() {
        return this.timestampUnit;
    }

    public TimestampUnit getDateTimeUnit() {
        return this.dateTimeUnit;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static ArrowOptions createDefault() {
        return ArrowOptions.newBuilder().build();
    }

    public static enum TimestampUnit {
        SECOND,
        MILLI,
        MICRO,
        NANO;


        public String toString() {
            switch (this) {
                case SECOND: {
                    return "second";
                }
                case MILLI: {
                    return "milli";
                }
                case MICRO: {
                    return "micro";
                }
                case NANO: {
                    return "nano";
                }
            }
            throw new IllegalArgumentException("Unexpected time stamp unit");
        }
    }

    public static class Builder {
        private final ArrowOptions arrowOptions = new ArrowOptions();

        public Builder withTimestampUnit(TimestampUnit unit) {
            this.arrowOptions.timestampUnit = unit;
            return this;
        }

        public Builder withDatetimeUnit(TimestampUnit unit) {
            this.arrowOptions.dateTimeUnit = unit;
            return this;
        }

        public ArrowOptions build() {
            return this.arrowOptions;
        }
    }
}

