/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.configuration;

import com.aliyun.odps.commons.util.RetryStrategy;
import com.aliyun.odps.table.DataFormat;
import com.aliyun.odps.table.configuration.CompressionCodec;
import com.aliyun.odps.table.enviroment.EnvironmentSettings;
import com.aliyun.odps.table.utils.ArrowUtils;
import com.aliyun.odps.table.utils.Preconditions;
import java.util.Optional;
import org.apache.arrow.memory.BufferAllocator;

public class WriterOptions {
    private RetryStrategy retryStrategy = new RetryStrategy();
    private int bufferedRowCount = 4096;
    private BufferAllocator bufferAllocator = ArrowUtils.getDefaultRootAllocator();
    private EnvironmentSettings settings;
    private int chunkSize = 0x400000;
    private CompressionCodec compressionCodec = CompressionCodec.NO_COMPRESSION;
    private DataFormat dataFormat = ArrowUtils.getDefaultDataFormat();
    private long maxBlockNumber = -1L;

    public int getBufferedRowCount() {
        return this.bufferedRowCount;
    }

    public BufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public EnvironmentSettings getSettings() {
        return this.settings;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public CompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    public Optional<Long> maxBlockNumber() {
        return this.maxBlockNumber > 0L ? Optional.of(this.maxBlockNumber) : Optional.empty();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final WriterOptions writerOptions = new WriterOptions();

        public Builder withBufferedRowCount(int bufferSize) {
            Preconditions.checkInteger((Integer)bufferSize, (int)1, (String)"Buffered row count");
            this.writerOptions.bufferedRowCount = bufferSize;
            return this;
        }

        public Builder withRetryStrategy(RetryStrategy retryStrategy) {
            Preconditions.checkNotNull((Object)retryStrategy, (String)"Retry strategy");
            this.writerOptions.retryStrategy = retryStrategy;
            return this;
        }

        public Builder withBufferAllocator(BufferAllocator allocator) {
            Preconditions.checkNotNull((Object)allocator, (String)"Buffer allocator");
            this.writerOptions.bufferAllocator = allocator;
            return this;
        }

        public Builder withSettings(EnvironmentSettings settings) {
            this.writerOptions.settings = settings;
            return this;
        }

        public Builder withChunkSize(int chunkSize) {
            Preconditions.checkInteger((Integer)chunkSize, (int)1496, (String)"Chunk size");
            this.writerOptions.chunkSize = chunkSize;
            return this;
        }

        public Builder withDataFormat(DataFormat dataFormat) {
            Preconditions.checkNotNull((Object)dataFormat, (String)"Data format");
            this.writerOptions.dataFormat = dataFormat;
            return this;
        }

        public Builder withCompressionCodec(CompressionCodec codec) {
            this.writerOptions.compressionCodec = codec;
            return this;
        }

        public Builder withMaxBlockNumber(long maxBlockNumber) {
            Preconditions.checkLong((Long)maxBlockNumber, (long)1L, (String)"MaxBlockNumber");
            this.writerOptions.maxBlockNumber = maxBlockNumber;
            return this;
        }

        public WriterOptions build() {
            Preconditions.checkNotNull((Object)this.writerOptions.settings, (String)"Environment settings", (String)"required");
            return this.writerOptions;
        }
    }
}

