/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.enviroment;

import com.aliyun.odps.table.configuration.RestOptions;
import com.aliyun.odps.table.enviroment.Credentials;
import com.aliyun.odps.table.utils.Preconditions;
import java.util.Optional;

public class EnvironmentSettings {
    private final ExecutionMode executionMode;
    private final String quotaName;
    private final Credentials credentials;
    private final String defaultProject;
    private final String defaultSchema;
    private final String serviceEndpoint;
    private final String tunnelEndpoint;
    private final RestOptions restOptions;
    private final Long slotNum;

    private EnvironmentSettings(Builder builder) {
        this.executionMode = builder.executionMode;
        this.quotaName = builder.quotaName;
        this.credentials = builder.credentials;
        this.defaultProject = builder.defaultProject;
        this.defaultSchema = builder.defaultSchema;
        this.serviceEndpoint = builder.serviceEndPoint;
        this.tunnelEndpoint = builder.tunnelEndpoint;
        this.restOptions = builder.restOptions;
        this.slotNum = builder.slotNum;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Optional<String> getQuotaName() {
        return Optional.ofNullable(this.quotaName);
    }

    public Optional<String> getDefaultProject() {
        return Optional.ofNullable(this.defaultProject);
    }

    public Optional<String> getDefaultSchema() {
        return Optional.ofNullable(this.defaultSchema);
    }

    public Optional<String> getServiceEndpoint() {
        return Optional.ofNullable(this.serviceEndpoint);
    }

    public Optional<String> getTunnelEndpoint() {
        return Optional.ofNullable(this.tunnelEndpoint);
    }

    public Optional<RestOptions> getRestOptions() {
        return Optional.ofNullable(this.restOptions);
    }

    public Optional<Long> getSlotNum() {
        return Optional.ofNullable(this.slotNum);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ExecutionMode executionMode = ExecutionMode.AUTOMATIC;
        private Credentials credentials;
        private String defaultProject;
        private String defaultSchema;
        private String quotaName;
        private String serviceEndPoint;
        private String tunnelEndpoint;
        private RestOptions restOptions;
        private Long slotNum;

        public Builder inLocalMode() {
            this.executionMode = ExecutionMode.LOCAL;
            return this;
        }

        public Builder inRemoteMode() {
            this.executionMode = ExecutionMode.REMOTE;
            return this;
        }

        public Builder inAutoMode() {
            this.executionMode = ExecutionMode.AUTOMATIC;
            return this;
        }

        public Builder withCredentials(Credentials credentials) {
            Preconditions.checkNotNull((Object)credentials, (String)"Credentials");
            this.credentials = credentials;
            return this;
        }

        public Builder withDefaultProject(String projectName) {
            Preconditions.checkString((String)projectName, (String)"Project");
            this.defaultProject = projectName;
            return this;
        }

        public Builder withDefaultSchema(String schema) {
            Preconditions.checkString((String)schema, (String)"Schema");
            this.defaultSchema = schema;
            return this;
        }

        public Builder withServiceEndpoint(String endPoint) {
            Preconditions.checkString((String)endPoint, (String)"End point");
            this.serviceEndPoint = endPoint;
            return this;
        }

        public Builder withTunnelEndpoint(String endPoint) {
            Preconditions.checkString((String)endPoint, (String)"Tunnel end point");
            this.tunnelEndpoint = endPoint;
            return this;
        }

        public Builder withQuotaName(String quotaName) {
            this.quotaName = quotaName;
            return this;
        }

        public Builder withRestOptions(RestOptions restOptions) {
            Preconditions.checkNotNull((Object)restOptions, (String)"Rest Options");
            this.restOptions = restOptions;
            return this;
        }

        public Builder withSlotNum(Long slotNum) {
            Preconditions.checkLong((Long)slotNum, (long)1L, (String)"Slot num");
            this.slotNum = slotNum;
            return this;
        }

        public EnvironmentSettings build() {
            Preconditions.checkNotNull((Object)this.credentials, (String)"Credentials", (String)"required");
            return new EnvironmentSettings(this);
        }
    }

    public static enum ExecutionMode {
        REMOTE,
        LOCAL,
        AUTOMATIC;

    }
}

