/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.enviroment;

import com.aliyun.odps.table.enviroment.EnvironmentSettings;
import com.aliyun.odps.table.enviroment.ExecutionEnvironment;
import com.aliyun.odps.table.utils.Preconditions;
import com.aliyun.odps.utils.StringUtils;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalEnvironment
extends ExecutionEnvironment {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionEnvironment.class);
    private String localEndpoint = null;

    public LocalEnvironment(EnvironmentSettings settings) {
        super(settings);
    }

    @Override
    protected void initialize() {
        String mode = System.getenv("MAX_STORAGE_MODE");
        if (StringUtils.isNullOrEmpty((String)mode)) {
            logger.warn("Local env without maxstorage mode");
            return;
        }
        String prefix = System.getenv("MAX_STORAGE_DATA_PROXY_PREFIX");
        String port = System.getenv("MAX_STORAGE_DATA_PROXY_PORT");
        Preconditions.checkString((String)port, (String)"MAX_STORAGE_DATA_PROXY_PORT");
        String localHostPort = StringUtils.isNullOrEmpty((String)prefix) ? "http://127.0.0.1:" + port : "http://127.0.0.1:" + port + "/" + prefix;
        this.localEndpoint = localHostPort;
    }

    @Override
    public String getTunnelEndpoint(String targetProject) {
        this.ensureInitialized();
        return Optional.ofNullable(this.localEndpoint).orElseGet(() -> this.settings.getTunnelEndpoint().orElseThrow(() -> new IllegalStateException("Local environment get empty tunnel endpoint!")));
    }
}

