/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.read.impl.batch;

import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.table.DataFormat;
import com.aliyun.odps.table.DataSchema;
import com.aliyun.odps.table.SessionStatus;
import com.aliyun.odps.table.TableIdentifier;
import com.aliyun.odps.table.configuration.ArrowOptions;
import com.aliyun.odps.table.configuration.SplitOptions;
import com.aliyun.odps.table.enviroment.EnvironmentSettings;
import com.aliyun.odps.table.optimizer.predicate.Predicate;
import com.aliyun.odps.table.read.TableBatchReadSession;
import com.aliyun.odps.table.read.split.InputSplitAssigner;
import com.aliyun.odps.table.utils.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class TableBatchReadSessionBase
implements TableBatchReadSession {
    private static final long serialVersionUID = 1L;
    protected transient List<PartitionSpec> requiredPartitions;
    protected transient List<String> requiredDataColumns;
    protected transient List<String> requiredPartitionColumns;
    protected transient List<Integer> requiredBucketIds;
    protected transient SplitOptions splitOptions;
    protected transient ArrowOptions arrowOptions;
    protected transient EnvironmentSettings settings;
    protected String sessionId;
    protected TableIdentifier identifier;
    protected DataSchema readSchema;
    protected long expirationTime;
    protected SessionStatus sessionStatus;
    protected InputSplitAssigner inputSplitAssigner;
    protected String errorMessage;
    protected Set<DataFormat> supportDataFormats;
    protected Predicate filterPredicate;

    public TableBatchReadSessionBase(TableIdentifier identifier, List<PartitionSpec> requiredPartitions, List<String> requiredDataColumns, List<String> requiredPartitionColumns, List<Integer> bucketIds, SplitOptions splitOptions, ArrowOptions arrowOptions, EnvironmentSettings settings, Predicate filterPredicate) throws IOException {
        Preconditions.checkNotNull((Object)identifier, (String)"Table identifier", (String)"required");
        Preconditions.checkNotNull((Object)settings, (String)"Environment settings", (String)"required");
        this.identifier = identifier;
        this.settings = settings;
        this.sessionStatus = SessionStatus.UNKNOWN;
        this.sanitize(requiredPartitions, requiredDataColumns, requiredPartitionColumns, bucketIds, splitOptions, arrowOptions, filterPredicate);
        this.planInputSplits();
    }

    public TableBatchReadSessionBase(TableIdentifier identifier, String sessionId, EnvironmentSettings settings) throws IOException {
        Preconditions.checkNotNull((Object)identifier, (String)"Table identifier", (String)"required");
        Preconditions.checkNotNull((Object)sessionId, (String)"Table read session id", (String)"required");
        Preconditions.checkNotNull((Object)settings, (String)"Environment settings", (String)"required");
        this.identifier = identifier;
        this.sessionId = sessionId;
        this.settings = settings;
        this.sessionStatus = SessionStatus.UNKNOWN;
        this.reloadInputSplits();
    }

    protected abstract void planInputSplits() throws IOException;

    protected abstract String reloadInputSplits() throws IOException;

    private void sanitize(List<PartitionSpec> partitions, List<String> dataColumns, List<String> partitionColumns, List<Integer> bucketIds, SplitOptions splitOptions, ArrowOptions arrowOptions, Predicate filterPredicate) {
        this.requiredPartitions = partitions == null ? Collections.emptyList() : Collections.unmodifiableList(partitions);
        this.requiredDataColumns = dataColumns == null ? Collections.emptyList() : Collections.unmodifiableList(dataColumns);
        this.requiredPartitionColumns = partitionColumns == null ? Collections.emptyList() : Collections.unmodifiableList(partitionColumns);
        this.requiredBucketIds = bucketIds == null ? Collections.emptyList() : Collections.unmodifiableList(bucketIds);
        this.splitOptions = splitOptions == null ? SplitOptions.createDefault() : splitOptions;
        this.arrowOptions = arrowOptions == null ? ArrowOptions.createDefault() : arrowOptions;
        this.filterPredicate = filterPredicate == null ? Predicate.NO_PREDICATE : filterPredicate;
        Preconditions.checkIntList(this.requiredBucketIds, (int)0, (int)0, (String)"requiredBucketIds");
        Preconditions.checkList(this.requiredPartitions, (int)0, (String)"partitionsFilters");
    }

    @Override
    public InputSplitAssigner getInputSplitAssigner() {
        if (this.inputSplitAssigner != null) {
            return this.inputSplitAssigner;
        }
        throw new IllegalStateException("The table read has not been initialized yet");
    }

    @Override
    public String getId() {
        if (this.sessionId != null) {
            return this.sessionId;
        }
        throw new IllegalStateException("The table read has not been initialized yet");
    }

    @Override
    public DataSchema readSchema() {
        if (this.readSchema != null) {
            return this.readSchema;
        }
        throw new IllegalStateException("The table read has not been initialized yet");
    }

    @Override
    public TableIdentifier getTableIdentifier() {
        return this.identifier;
    }

    @Override
    public SessionStatus getStatus() {
        return this.sessionStatus;
    }
}

