/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.record.constructor;

import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.table.arrow.constructor.ArrowArrayWriter;
import com.aliyun.odps.table.arrow.constructor.ArrowFieldWriter;
import com.aliyun.odps.table.record.constructor.ArrowBigIntWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowBitWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowDateDayWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowDateTimeWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowDecimalWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowFloat4WriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowFloat8WriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowIntWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowMapWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowSmallIntWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowStructWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowTimeStampWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowTinyIntWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowVarBinaryWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowVarCharWriterImpl;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import java.util.List;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;

public class ArrowArrayWriterImpl {
    public static ArrowFieldWriter<List<Object>> createArrowFieldWriterForList(ValueVector vector, TypeInfo typeInfo) {
        switch (typeInfo.getOdpsType()) {
            case BOOLEAN: {
                return new ArrowBitWriterImpl.ListBitWriter((BitVector)vector);
            }
            case TINYINT: {
                return new ArrowTinyIntWriterImpl.ListTinyIntWriter((TinyIntVector)vector);
            }
            case SMALLINT: {
                return new ArrowSmallIntWriterImpl.ListSmallIntWriter((SmallIntVector)vector);
            }
            case INT: {
                return new ArrowIntWriterImpl.ListIntWriter((IntVector)vector);
            }
            case BIGINT: {
                return new ArrowBigIntWriterImpl.ListBigIntWriter((BigIntVector)vector);
            }
            case FLOAT: {
                return new ArrowFloat4WriterImpl.ListFloat4Writer((Float4Vector)vector);
            }
            case DOUBLE: {
                return new ArrowFloat8WriterImpl.ListFloat8Writer((Float8Vector)vector);
            }
            case DECIMAL: {
                return new ArrowDecimalWriterImpl.ListDecimalWriter((DecimalVector)vector, typeInfo);
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return new ArrowVarCharWriterImpl.ListVarCharWriter((VarCharVector)vector);
            }
            case BINARY: {
                return new ArrowVarBinaryWriterImpl.ListVarBinaryWriter((VarBinaryVector)vector);
            }
            case DATE: {
                return new ArrowDateDayWriterImpl.ListDateWriter((DateDayVector)vector);
            }
            case DATETIME: {
                return new ArrowDateTimeWriterImpl.ListDateTimeWriter((TimeStampVector)vector);
            }
            case TIMESTAMP: {
                return new ArrowTimeStampWriterImpl.ListTimeStampWriter((TimeStampVector)vector);
            }
            case ARRAY: {
                return new ListArrayWriter((ListVector)vector, typeInfo);
            }
            case MAP: {
                return new ArrowMapWriterImpl.ListMapWriter((MapVector)vector, typeInfo);
            }
            case STRUCT: {
                return new ArrowStructWriterImpl.ListStructWriter((StructVector)vector, typeInfo);
            }
        }
        throw new UnsupportedOperationException("Datatype not supported: " + typeInfo.getTypeName());
    }

    public static final class StructArrayWriter
    extends ArrowArrayWriterBase<Struct> {
        StructArrayWriter(ListVector listVector, TypeInfo typeInfo) {
            super(listVector, typeInfo);
        }

        @Override
        protected boolean isNullAt(Struct in, int ordinal) {
            return in.getFieldValue(ordinal) == null;
        }

        @Override
        protected List<Object> readArray(Struct in, int ordinal) {
            return (List)in.getFieldValue(ordinal);
        }
    }

    public static final class ListArrayWriter
    extends ArrowArrayWriterBase<List<Object>> {
        ListArrayWriter(ListVector listVector, TypeInfo typeInfo) {
            super(listVector, typeInfo);
        }

        @Override
        protected boolean isNullAt(List<Object> in, int ordinal) {
            return in.get(ordinal) == null;
        }

        @Override
        protected List<Object> readArray(List<Object> in, int ordinal) {
            return (List)in.get(ordinal);
        }
    }

    public static final class RecordArrayWriter
    extends ArrowArrayWriterBase<ArrayRecord> {
        RecordArrayWriter(ListVector listVector, TypeInfo typeInfo) {
            super(listVector, typeInfo);
        }

        @Override
        protected List<Object> readArray(ArrayRecord record, int ordinal) {
            return record.getArray(ordinal);
        }

        @Override
        protected boolean isNullAt(ArrayRecord record, int ordinal) {
            return record.isNull(ordinal);
        }
    }

    public static abstract class ArrowArrayWriterBase<IN>
    extends ArrowArrayWriter<IN, List<Object>> {
        public ArrowArrayWriterBase(ListVector listVector, TypeInfo typeInfo) {
            super(listVector, ArrowArrayWriterImpl.createArrowFieldWriterForList((ValueVector)listVector.getDataVector(), ((ArrayTypeInfo)typeInfo).getElementTypeInfo()));
        }

        @Override
        protected int numElements(List<Object> arrayData) {
            return arrayData.size();
        }
    }
}

