/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.record.constructor;

import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.table.arrow.constructor.ArrowBitWriter;
import java.util.List;
import org.apache.arrow.vector.BitVector;

public class ArrowBitWriterImpl {

    public static final class StructBitWriter
    extends ArrowBitWriter<Struct> {
        StructBitWriter(BitVector bitVector) {
            super(bitVector);
        }

        @Override
        protected boolean isNullAt(Struct in, int ordinal) {
            return in.getFieldValue(ordinal) == null;
        }

        @Override
        protected boolean readBoolean(Struct in, int ordinal) {
            return (Boolean)in.getFieldValue(ordinal);
        }
    }

    public static final class ListBitWriter
    extends ArrowBitWriter<List<Object>> {
        ListBitWriter(BitVector bitVector) {
            super(bitVector);
        }

        @Override
        protected boolean isNullAt(List<Object> in, int ordinal) {
            return in.get(ordinal) == null;
        }

        @Override
        protected boolean readBoolean(List<Object> in, int ordinal) {
            return (Boolean)in.get(ordinal);
        }
    }

    public static final class RecordBitWriter
    extends ArrowBitWriter<ArrayRecord> {
        RecordBitWriter(BitVector bitVector) {
            super(bitVector);
        }

        @Override
        protected boolean isNullAt(ArrayRecord row, int ordinal) {
            return row.isNull(ordinal);
        }

        @Override
        protected boolean readBoolean(ArrayRecord row, int ordinal) {
            return row.getBoolean(ordinal);
        }
    }
}

