/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.record.constructor;

import com.aliyun.odps.data.AbstractChar;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.table.arrow.constructor.ArrowVarCharWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.arrow.vector.VarCharVector;

public class ArrowVarCharWriterImpl {
    private static byte[] stringToBytes(String string) {
        try {
            return string.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static final class StructVarCharWriter
    extends ArrowVarCharWriterBase<Struct> {
        StructVarCharWriter(VarCharVector varCharVector) {
            super(varCharVector);
        }

        @Override
        protected boolean isNullAt(Struct in, int ordinal) {
            return in.getFieldValue(ordinal) == null;
        }

        @Override
        protected byte[] readBytes(Struct in, int ordinal) {
            Object v = in.getFieldValue(ordinal);
            if (v instanceof String) {
                return ArrowVarCharWriterImpl.stringToBytes((String)v);
            }
            if (v instanceof AbstractChar) {
                return ArrowVarCharWriterImpl.stringToBytes(((AbstractChar)v).getValue());
            }
            return (byte[])v;
        }
    }

    public static final class ListVarCharWriter
    extends ArrowVarCharWriterBase<List<Object>> {
        ListVarCharWriter(VarCharVector varCharVector) {
            super(varCharVector);
        }

        @Override
        protected boolean isNullAt(List<Object> in, int ordinal) {
            return in.get(ordinal) == null;
        }

        @Override
        protected byte[] readBytes(List<Object> row, int ordinal) {
            Object v = row.get(ordinal);
            if (v instanceof String) {
                return ArrowVarCharWriterImpl.stringToBytes((String)v);
            }
            if (v instanceof AbstractChar) {
                return ArrowVarCharWriterImpl.stringToBytes(((AbstractChar)v).getValue());
            }
            return (byte[])v;
        }
    }

    public static final class RecordVarCharWriter
    extends ArrowVarCharWriterBase<ArrayRecord> {
        RecordVarCharWriter(VarCharVector varCharVector) {
            super(varCharVector);
        }

        @Override
        protected byte[] readBytes(ArrayRecord record, int ordinal) {
            return record.getBytes(ordinal);
        }

        @Override
        protected boolean isNullAt(ArrayRecord row, int ordinal) {
            return row.isNull(ordinal);
        }
    }

    public static abstract class ArrowVarCharWriterBase<IN>
    extends ArrowVarCharWriter<IN> {
        ArrowVarCharWriterBase(VarCharVector varCharVector) {
            super(varCharVector);
        }

        protected abstract byte[] readBytes(IN var1, int var2);

        @Override
        protected void setValue(IN in, int ordinal) {
            ((VarCharVector)this.valueVector).setSafe(this.count, this.readBytes(in, ordinal));
        }
    }
}

