/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.record.constructor;

import com.aliyun.odps.Column;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.table.arrow.constructor.ArrowBatchConstructor;
import com.aliyun.odps.table.arrow.constructor.ArrowFieldWriter;
import com.aliyun.odps.table.record.constructor.ArrowArrayWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowBigIntWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowBitWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowDateDayWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowDateTimeWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowDecimalWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowFloat4WriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowFloat8WriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowIntWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowMapWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowSmallIntWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowStructWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowTimeStampWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowTinyIntWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowVarBinaryWriterImpl;
import com.aliyun.odps.table.record.constructor.ArrowVarCharWriterImpl;
import com.aliyun.odps.table.utils.SchemaUtils;
import com.aliyun.odps.type.TypeInfo;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.types.pojo.Schema;

public class RecordToArrowConverter {
    public static ArrowBatchConstructor<ArrayRecord> createRecordArrowBatchConstructor(List<Column> dataColumns, BufferAllocator allocator) {
        Schema arrowSchema = SchemaUtils.toArrowSchema(dataColumns);
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)arrowSchema, (BufferAllocator)allocator);
        return RecordToArrowConverter.createRecordArrowBatchConstructor(dataColumns, root);
    }

    public static ArrowBatchConstructor<ArrayRecord> createRecordArrowBatchConstructor(List<Column> dataColumns, VectorSchemaRoot root) {
        ArrowFieldWriter[] fieldWriters = new ArrowFieldWriter[root.getFieldVectors().size()];
        List vectors = root.getFieldVectors();
        if (vectors.size() != dataColumns.size()) {
            throw new RuntimeException();
        }
        for (int i = 0; i < vectors.size(); ++i) {
            FieldVector vector = (FieldVector)vectors.get(i);
            vector.allocateNew();
            fieldWriters[i] = RecordToArrowConverter.createArrowFieldWriterForRecord((ValueVector)vector, dataColumns.get(i).getTypeInfo());
        }
        return new ArrowBatchConstructor<ArrayRecord>(root, fieldWriters);
    }

    public static ArrowFieldWriter<ArrayRecord> createArrowFieldWriterForRecord(ValueVector vector, TypeInfo typeInfo) {
        switch (typeInfo.getOdpsType()) {
            case BOOLEAN: {
                return new ArrowBitWriterImpl.RecordBitWriter((BitVector)vector);
            }
            case TINYINT: {
                return new ArrowTinyIntWriterImpl.RecordTinyIntWriter((TinyIntVector)vector);
            }
            case SMALLINT: {
                return new ArrowSmallIntWriterImpl.RecordSmallIntWriter((SmallIntVector)vector);
            }
            case INT: {
                return new ArrowIntWriterImpl.RecordIntWriter((IntVector)vector);
            }
            case BIGINT: {
                return new ArrowBigIntWriterImpl.RecordBigIntWriter((BigIntVector)vector);
            }
            case FLOAT: {
                return new ArrowFloat4WriterImpl.RecordFloat4Writer((Float4Vector)vector);
            }
            case DOUBLE: {
                return new ArrowFloat8WriterImpl.RecordFloat8Writer((Float8Vector)vector);
            }
            case DECIMAL: {
                return new ArrowDecimalWriterImpl.RecordDecimalWriter((DecimalVector)vector, typeInfo);
            }
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return new ArrowVarCharWriterImpl.RecordVarCharWriter((VarCharVector)vector);
            }
            case BINARY: {
                return new ArrowVarBinaryWriterImpl.RecordVarBinaryWriter((VarBinaryVector)vector);
            }
            case DATE: {
                return new ArrowDateDayWriterImpl.RecordDateWriter((DateDayVector)vector);
            }
            case DATETIME: {
                return new ArrowDateTimeWriterImpl.RecordDateTimeWriter((TimeStampVector)vector);
            }
            case TIMESTAMP: {
                return new ArrowTimeStampWriterImpl.RecordTimeStampWriter((TimeStampVector)vector);
            }
            case ARRAY: {
                return new ArrowArrayWriterImpl.RecordArrayWriter((ListVector)vector, typeInfo);
            }
            case MAP: {
                return new ArrowMapWriterImpl.RecordMapWriter((MapVector)vector, typeInfo);
            }
            case STRUCT: {
                return new ArrowStructWriterImpl.RecordStructWriter((StructVector)vector, typeInfo);
            }
        }
        throw new UnsupportedOperationException("Datatype not supported: " + typeInfo.getTypeName());
    }
}

