/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.write;

import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.Table;
import com.aliyun.odps.table.TableIdentifier;
import com.aliyun.odps.table.configuration.ArrowOptions;
import com.aliyun.odps.table.configuration.DynamicPartitionOptions;
import com.aliyun.odps.table.enviroment.EnvironmentSettings;
import com.aliyun.odps.table.utils.SessionUtils;
import com.aliyun.odps.table.write.TableBatchWriteSession;
import com.aliyun.odps.table.write.TableStreamingWriteSession;
import com.aliyun.odps.table.write.TableUpsertSession;
import com.aliyun.odps.table.write.TableWriteCapabilities;
import com.aliyun.odps.table.write.TableWriteSessionProvider;
import com.aliyun.odps.table.write.impl.TableWriteSessionProviderImpl;
import java.io.IOException;

public class TableWriteSessionBuilder {
    private TableIdentifier identifier;
    private PartitionSpec targetPartitionSpec;
    private boolean overwrite = false;
    private DynamicPartitionOptions dynamicPartitionOptions;
    private ArrowOptions arrowOptions;
    private TableWriteCapabilities writeCapabilities;
    private EnvironmentSettings settings;
    private String sessionId;
    private String sessionProvider;
    private long maxFieldSize = 0x800000L;

    public TableWriteSessionBuilder table(Table table) {
        this.identifier = TableIdentifier.of((String)table.getProject(), (String)table.getSchemaName(), (String)table.getName());
        return this;
    }

    public TableWriteSessionBuilder identifier(TableIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public TableWriteSessionBuilder partition(PartitionSpec partitionSpec) {
        this.targetPartitionSpec = partitionSpec;
        return this;
    }

    public TableWriteSessionBuilder overwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    public TableWriteSessionBuilder withDynamicPartitionOptions(DynamicPartitionOptions options) {
        this.dynamicPartitionOptions = options;
        return this;
    }

    public TableWriteSessionBuilder withArrowOptions(ArrowOptions options) {
        this.arrowOptions = options;
        return this;
    }

    public TableWriteSessionBuilder withCapabilities(TableWriteCapabilities capabilities) {
        this.writeCapabilities = capabilities;
        return this;
    }

    public TableWriteSessionBuilder withSettings(EnvironmentSettings settings) {
        this.settings = settings;
        return this;
    }

    public TableWriteSessionBuilder withSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public TableWriteSessionBuilder withSessionProvider(String provider) {
        this.sessionProvider = provider;
        return this;
    }

    public TableWriteSessionBuilder withMaxFieldSize(long maxFieldSize) {
        this.maxFieldSize = maxFieldSize;
        return this;
    }

    public TableBatchWriteSession buildBatchWriteSession() throws IOException {
        return this.getProvider().createBatchWriteSession(this);
    }

    public TableStreamingWriteSession buildStreamingWriteSession() throws IOException {
        return this.getProvider().createStreamingWriteSession(this);
    }

    public TableUpsertSession buildUpsertSession() throws IOException {
        return this.getProvider().createUpsertSession(this);
    }

    public TableIdentifier getIdentifier() {
        return this.identifier;
    }

    public PartitionSpec getTargetPartitionSpec() {
        return this.targetPartitionSpec;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public EnvironmentSettings getSettings() {
        return this.settings;
    }

    public ArrowOptions getArrowOptions() {
        return this.arrowOptions;
    }

    public DynamicPartitionOptions getDynamicPartitionOptions() {
        return this.dynamicPartitionOptions;
    }

    public TableWriteCapabilities getWriteCapabilities() {
        return this.writeCapabilities;
    }

    public long getMaxFieldSize() {
        return this.maxFieldSize;
    }

    private TableWriteSessionProvider getProvider() throws IOException {
        try {
            return this.sessionProvider != null ? SessionUtils.discoverSessionProvider(TableWriteSessionBuilder.class.getClassLoader(), TableWriteSessionProvider.class, this.sessionProvider) : new TableWriteSessionProviderImpl();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(String.format("Unable to create a table batch read session for reading table '%s'.\n\nSession provider are:\n\n%s", this.identifier.toString(), this.sessionProvider), e);
        }
    }
}

