/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.arrow.readers;

import com.aliyun.odps.table.arrow.ArrowReader;
import java.io.IOException;
import java.io.InputStream;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.compression.CompressionCodec;
import org.apache.arrow.vector.ipc.ArrowStreamReader;

public class ArrowBatchReusedReader
implements ArrowReader {
    private final ArrowStreamReader arrowReader;
    private VectorSchemaRoot currentBatch;

    public ArrowBatchReusedReader(InputStream is, BufferAllocator allocator) {
        this.arrowReader = new ArrowStreamReader(is, allocator);
        this.currentBatch = null;
    }

    public ArrowBatchReusedReader(InputStream is, BufferAllocator allocator, CompressionCodec.Factory compressionFactory) {
        this.arrowReader = new ArrowStreamReader(is, allocator, compressionFactory);
        this.currentBatch = null;
    }

    @Override
    public VectorSchemaRoot getCurrentValue() {
        return this.currentBatch;
    }

    @Override
    public boolean nextBatch() throws IOException {
        boolean hasNext = this.arrowReader.loadNextBatch();
        this.currentBatch = hasNext ? this.arrowReader.getVectorSchemaRoot() : null;
        return hasNext;
    }

    @Override
    public void close() throws IOException {
        this.arrowReader.close();
    }

    @Override
    public long bytesRead() {
        return this.arrowReader.bytesRead();
    }
}

