/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.configuration;

import java.io.Serializable;
import java.util.Optional;

public class RestOptions
implements Serializable {
    private String userAgent;
    private Integer connectTimeout;
    private Integer readTimeout;
    private Integer retryTimes;
    private Boolean ignoreCerts;
    private Long asyncIntervalInMills;
    private Integer asyncTimeoutInSeconds;
    private Integer upsertConcurrentNum;
    private Integer upsertNetworkNum;

    private RestOptions() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<Integer> getReadTimeout() {
        return Optional.ofNullable(this.readTimeout);
    }

    public Optional<Integer> getConnectTimeout() {
        return Optional.ofNullable(this.connectTimeout);
    }

    public Optional<String> getUserAgent() {
        return Optional.ofNullable(this.userAgent);
    }

    public Optional<Integer> getRetryTimes() {
        return Optional.ofNullable(this.retryTimes);
    }

    public Optional<Boolean> isIgnoreCerts() {
        return Optional.ofNullable(this.ignoreCerts);
    }

    public Optional<Integer> getUpsertConcurrentNum() {
        return Optional.ofNullable(this.upsertConcurrentNum);
    }

    public Optional<Integer> getUpsertNetworkNum() {
        return Optional.ofNullable(this.upsertNetworkNum);
    }

    public Optional<Long> getAsyncIntervalInMills() {
        return Optional.ofNullable(this.asyncIntervalInMills);
    }

    public Optional<Integer> getAsyncTimeoutInSeconds() {
        return Optional.ofNullable(this.asyncTimeoutInSeconds);
    }

    public static class Builder {
        private final RestOptions restOptions = new RestOptions();

        public Builder witUserAgent(String userAgent) {
            this.restOptions.userAgent = userAgent;
            return this;
        }

        public Builder withConnectTimeout(int connectTimeout) {
            this.restOptions.connectTimeout = connectTimeout;
            return this;
        }

        public Builder withReadTimeout(int readTimeout) {
            this.restOptions.readTimeout = readTimeout;
            return this;
        }

        public Builder withRetryTimes(int retryTimes) {
            this.restOptions.retryTimes = retryTimes;
            return this;
        }

        public Builder withIgnoreCerts(boolean ignoreCerts) {
            this.restOptions.ignoreCerts = ignoreCerts;
            return this;
        }

        public Builder withAsyncIntervalInMillis(long asyncIntervalInMills) {
            this.restOptions.asyncIntervalInMills = asyncIntervalInMills;
            return this;
        }

        public Builder withAsyncTimeoutInSeconds(int asyncTimeoutInSeconds) {
            this.restOptions.asyncTimeoutInSeconds = asyncTimeoutInSeconds;
            return this;
        }

        public Builder withUpsertConcurrentNum(int upsertConcurrentNum) {
            this.restOptions.upsertConcurrentNum = upsertConcurrentNum;
            return this;
        }

        public Builder withUpsertNetworkNum(int upsertNetworkNum) {
            this.restOptions.upsertNetworkNum = upsertNetworkNum;
            return this;
        }

        public RestOptions build() {
            return this.restOptions;
        }
    }
}

