/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.record;

import com.aliyun.odps.Column;
import com.aliyun.odps.data.AbstractChar;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.table.arrow.accessor.ArrowVectorAccessor;
import com.aliyun.odps.table.record.accessor.ArrowToRecordConverter;
import com.aliyun.odps.type.TypeInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;

public class ColumnarBatchRecord
extends ArrayRecord {
    private final VectorSchemaRoot root;
    private int rowId;
    private ArrowVectorAccessor[] columnAccessors;
    private Map<String, Integer> nameMap = new HashMap<String, Integer>();

    private void checkSchema(Schema schema, Column[] columns) {
        if (columns.length != schema.getFields().size()) {
            throw new RuntimeException("The quality of field type is incompatible with the request schema!");
        }
        for (int i = 0; i < columns.length; ++i) {
            Field field = (Field)schema.getFields().get(i);
            if (field.getName().equals(columns[i].getName())) continue;
            throw new RuntimeException("Required column is incompatible in arrow batch. Col: " + field.getName());
        }
    }

    public ColumnarBatchRecord(VectorSchemaRoot root, Column[] columns) {
        this(root, columns, 0);
        this.checkSchema(root.getSchema(), columns);
        this.columnAccessors = new ArrowVectorAccessor[columns.length];
        this.nameMap = new HashMap<String, Integer>();
        List fieldVectors = root.getFieldVectors();
        for (int i = 0; i < fieldVectors.size(); ++i) {
            this.columnAccessors[i] = ArrowToRecordConverter.createColumnVectorAccessor((ValueVector)((ValueVector)fieldVectors.get(i)), (TypeInfo)columns[i].getTypeInfo());
            this.nameMap.put(columns[i].getName(), i);
        }
    }

    private ColumnarBatchRecord(VectorSchemaRoot root, Column[] columns, int rowId) {
        super(columns);
        this.root = root;
        this.rowId = rowId;
    }

    public void close() {
        if (this.root != null) {
            this.root.close();
        }
        this.rowId = 0;
    }

    public void setRowId(int rowId) {
        this.rowId = rowId;
    }

    public int getColumnCount() {
        return this.columnAccessors.length;
    }

    public void set(int idx, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object get(int idx) {
        try {
            return ArrowToRecordConverter.getData((ArrowVectorAccessor)this.columnAccessors[idx], (TypeInfo)this.getColumns()[idx].getTypeInfo(), (int)this.rowId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object get(String columnName) {
        return this.get(this.getColumnIndex(columnName));
    }

    public boolean isNull(int idx) {
        return this.columnAccessors[idx].isNullAt(this.rowId);
    }

    protected <T> T getInternal(int idx) {
        try {
            return (T)ArrowToRecordConverter.getData((ArrowVectorAccessor)this.columnAccessors[idx], (TypeInfo)this.getColumns()[idx].getTypeInfo(), (int)this.rowId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getString(int idx) {
        Object obj = this.getInternal(idx);
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return ColumnarBatchRecord.bytesToString((byte[])((byte[])obj));
        }
        return (String)obj;
    }

    public byte[] getBytes(int idx) {
        Object obj = this.getInternal(idx);
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof String) {
            return ColumnarBatchRecord.stringToBytes((String)((String)obj));
        }
        if (obj instanceof Binary) {
            return ((Binary)obj).data();
        }
        if (obj instanceof AbstractChar) {
            return ColumnarBatchRecord.stringToBytes((String)((AbstractChar)obj).getValue());
        }
        throw new RuntimeException("Does not support getBytes for type other than String/Binary/Char/VarChar, sees " + obj.getClass());
    }

    public Record clone() {
        ArrayRecord record = new ArrayRecord(this.getColumns());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.isNull(i)) {
                record.set(i, null);
                continue;
            }
            record.set(i, this.getInternal(i));
        }
        return record;
    }

    public void set(String columnName, Object value) {
        throw new UnsupportedOperationException();
    }

    public void set(Object[] values) {
        throw new UnsupportedOperationException();
    }

    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    private int getColumnIndex(String name) {
        Integer idx = this.nameMap.get(name);
        if (idx == null) {
            throw new IllegalArgumentException("No such column:" + name);
        }
        return idx;
    }
}

