/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.utils;

import com.aliyun.odps.Column;
import com.aliyun.odps.table.configuration.ArrowOptions;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.DecimalTypeInfo;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoParser;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;

public class SchemaUtils {
    public static final int DECIMAL_DEFAULT_PRECISION = 54;
    public static final int DECIMAL_DEFAULT_SCALE = 18;
    public static final int ARROW_DECIMAL_DEFAULT_PRECISION = 38;
    public static final int ARROW_DECIMAL_DEFAULT_SCALE = 18;

    public static Column parseColumn(JsonObject column) {
        String name = column.has("Name") ? column.get("Name").getAsString() : null;
        String type = column.has("Type") ? column.get("Type").getAsString() : null;
        String comment = column.has("Comment") ? column.get("Comment").getAsString() : null;
        TypeInfo typeInfo = TypeInfoParser.getTypeInfoFromTypeString((String)type);
        Column col = new Column(name, typeInfo, comment);
        if (column.has("Nullable")) {
            col.setNullable(column.get("Nullable").getAsBoolean());
        }
        return col;
    }

    public static Schema toArrowSchema(List<Column> columns) {
        return SchemaUtils.toArrowSchema(columns, ArrowOptions.createDefault());
    }

    public static Field columnToArrowField(Column fieldColumn) {
        return SchemaUtils.columnToArrowField(fieldColumn, ArrowOptions.createDefault());
    }

    public static Schema toArrowSchema(List<Column> columns, ArrowOptions arrowOptions) {
        Collection fields = columns.stream().map(col -> SchemaUtils.columnToArrowField(col, arrowOptions)).collect(Collectors.toCollection(ArrayList::new));
        return new Schema((Iterable)fields);
    }

    public static Field columnToArrowField(Column fieldColumn, ArrowOptions options) {
        String fieldName = fieldColumn.getName();
        TypeInfo typeInfo = fieldColumn.getTypeInfo();
        return SchemaUtils.convertTypeInfoToArrowField(fieldName, typeInfo, fieldColumn.isNullable(), options);
    }

    private static Field convertTypeInfoToArrowField(String fieldName, TypeInfo typeInfo, boolean nullable, ArrowOptions options) {
        ArrowType arrowType = SchemaUtils.getArrowType(typeInfo, options);
        return new Field(fieldName, new FieldType(nullable, arrowType, null, null), SchemaUtils.generateSubFields(typeInfo, options));
    }

    private static List<Field> generateSubFields(TypeInfo typeInfo, ArrowOptions options) {
        if (typeInfo instanceof ArrayTypeInfo) {
            ArrayTypeInfo arrayTypeInfo = (ArrayTypeInfo)typeInfo;
            TypeInfo subti = arrayTypeInfo.getElementTypeInfo();
            return Arrays.asList(SchemaUtils.convertTypeInfoToArrowField("element", subti, true, options));
        }
        if (typeInfo instanceof MapTypeInfo) {
            MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
            TypeInfo keyti = mapTypeInfo.getKeyTypeInfo();
            TypeInfo valti = mapTypeInfo.getValueTypeInfo();
            return Arrays.asList(new Field("element", new FieldType(false, (ArrowType)new ArrowType.Struct(), null, null), Arrays.asList(SchemaUtils.convertTypeInfoToArrowField("key", keyti, false, options), SchemaUtils.convertTypeInfoToArrowField("value", valti, true, options))));
        }
        if (typeInfo instanceof StructTypeInfo) {
            StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
            ArrayList<Field> sfields = new ArrayList<Field>();
            List subTypeInfos = structTypeInfo.getFieldTypeInfos();
            List subNames = structTypeInfo.getFieldNames();
            for (int i = 0; i < structTypeInfo.getFieldCount(); ++i) {
                sfields.add(SchemaUtils.convertTypeInfoToArrowField((String)subNames.get(i), (TypeInfo)subTypeInfos.get(i), true, options));
            }
            return sfields;
        }
        return null;
    }

    private static ArrowType getArrowType(TypeInfo typeInfo, ArrowOptions options) {
        ArrowType.Utf8 arrowType = null;
        switch (typeInfo.getOdpsType()) {
            case CHAR: 
            case VARCHAR: 
            case JSON: 
            case STRING: {
                arrowType = new ArrowType.Utf8();
                break;
            }
            case BINARY: {
                arrowType = new ArrowType.Binary();
                break;
            }
            case TINYINT: {
                arrowType = new ArrowType.Int(8, true);
                break;
            }
            case SMALLINT: {
                arrowType = new ArrowType.Int(16, true);
                break;
            }
            case INT: {
                arrowType = new ArrowType.Int(32, true);
                break;
            }
            case BIGINT: {
                arrowType = new ArrowType.Int(64, true);
                break;
            }
            case BOOLEAN: {
                arrowType = new ArrowType.Bool();
                break;
            }
            case FLOAT: {
                arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
                break;
            }
            case DOUBLE: {
                arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
                break;
            }
            case DECIMAL: {
                if (((DecimalTypeInfo)typeInfo).getPrecision() == 54 && ((DecimalTypeInfo)typeInfo).getScale() == 18) {
                    arrowType = new ArrowType.Decimal(38, 18);
                    break;
                }
                arrowType = new ArrowType.Decimal(((DecimalTypeInfo)typeInfo).getPrecision(), ((DecimalTypeInfo)typeInfo).getScale());
                break;
            }
            case DATE: {
                arrowType = new ArrowType.Date(DateUnit.DAY);
                break;
            }
            case DATETIME: {
                arrowType = SchemaUtils.parseTimeStamp(options.getDateTimeUnit());
                break;
            }
            case TIMESTAMP: 
            case TIMESTAMP_NTZ: {
                arrowType = SchemaUtils.parseTimeStamp(options.getTimestampUnit());
                break;
            }
            case ARRAY: {
                arrowType = new ArrowType.List();
                break;
            }
            case STRUCT: {
                arrowType = new ArrowType.Struct();
                break;
            }
            case MAP: {
                arrowType = new ArrowType.Map(false);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type: " + typeInfo.getOdpsType());
            }
        }
        return arrowType;
    }

    private static ArrowType.Timestamp parseTimeStamp(ArrowOptions.TimestampUnit unit) {
        switch (unit) {
            case SECOND: {
                return new ArrowType.Timestamp(TimeUnit.SECOND, null);
            }
            case MILLI: {
                return new ArrowType.Timestamp(TimeUnit.MILLISECOND, null);
            }
            case NANO: {
                return new ArrowType.Timestamp(TimeUnit.NANOSECOND, null);
            }
            case MICRO: {
                return new ArrowType.Timestamp(TimeUnit.MICROSECOND, null);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + (Object)((Object)unit));
    }
}

