/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table;

import com.aliyun.odps.Column;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoParser;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class DataSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Attribute> attributes;
    private final List<String> partitionKeys;
    private transient List<Column> columns;

    public DataSchema(List<Column> columns) {
        this(columns, new ArrayList<String>());
    }

    public DataSchema(List<Column> columns, List<String> partitionKeys) {
        Preconditions.checkNotNull(columns, (Object)"Columns must not be null.");
        Preconditions.checkNotNull(partitionKeys, (Object)"PartitionKeys must not be null.");
        this.attributes = columns.stream().map(DataSchema::columnToAttribute).collect(Collectors.toList());
        this.columns = columns;
        this.partitionKeys = Collections.unmodifiableList(partitionKeys);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Columns\n");
        for (Attribute column : this.attributes) {
            sb.append(" |-- ");
            sb.append(column.toString());
            sb.append('\n');
        }
        if (!this.partitionKeys.isEmpty()) {
            sb.append("PartitionKeys\n");
            for (String partitionKey : this.partitionKeys) {
                sb.append(" |-- ");
                sb.append(partitionKey);
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSchema that = (DataSchema)o;
        return Objects.equals(this.attributes, that.attributes) && Objects.equals(this.partitionKeys, that.partitionKeys);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.partitionKeys);
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        this.columns = this.attributes.stream().map(DataSchema::attributeToColumn).collect(Collectors.toList());
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<String> getPartitionKeys() {
        return this.partitionKeys;
    }

    public List<String> getColumnNames() {
        return this.columns.stream().map(Column::getName).collect(Collectors.toList());
    }

    public List<TypeInfo> getColumnDataTypes() {
        return this.columns.stream().map(Column::getTypeInfo).collect(Collectors.toList());
    }

    public Optional<Column> getColumn(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columns.size()) {
            return Optional.empty();
        }
        return Optional.of(this.columns.get(columnIndex));
    }

    public Optional<Column> getColumn(String columnName) {
        return this.columns.stream().filter(column -> column.getName().equals(columnName)).findFirst();
    }

    private static Attribute columnToAttribute(Column column) {
        return new Attribute(column.getName(), column.getTypeInfo().getTypeName(), column.isNullable());
    }

    private static Column attributeToColumn(Attribute attribute) {
        Column column = new Column(attribute.getName(), DataSchema.getTypeInfoFromString(attribute.getType()));
        column.setNullable(attribute.isNullable());
        return column;
    }

    private static TypeInfo getTypeInfoFromString(String typeName) {
        TypeInfo typeInfo = TypeInfoParser.getTypeInfoFromTypeString((String)typeName);
        if (typeInfo == null) {
            throw new IllegalArgumentException("Parse odps type info failed: " + typeName);
        }
        return typeInfo;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Attribute
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final String type;
        private final boolean nullable;

        public Attribute(String name, String type, boolean nullable) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Field name must not be null.");
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"Field data type must not be null.");
            this.nullable = nullable;
        }

        public final String getName() {
            return this.name;
        }

        public final String getType() {
            return this.type;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name);
            sb.append(": ");
            sb.append(this.type);
            sb.append(": ");
            sb.append(this.nullable);
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Attribute that = (Attribute)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }
    }

    public static class Builder {
        private List<Column> columns = new ArrayList<Column>();
        private List<String> partitionKeys = new ArrayList<String>();

        private Builder() {
        }

        public Builder columns(List<Column> columns) {
            this.columns = columns;
            return this;
        }

        public Builder partitionBy(List<String> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this;
        }

        public DataSchema build() {
            return new DataSchema(this.columns, this.partitionKeys);
        }
    }
}

