/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.arrow;

import com.aliyun.odps.table.arrow.ArrowReader;
import com.aliyun.odps.table.arrow.readers.ArrowBatchNonReusedReader;
import com.aliyun.odps.table.arrow.readers.ArrowBatchReusedReader;
import com.aliyun.odps.table.configuration.CompressionCodec;
import com.aliyun.odps.table.configuration.ReaderOptions;
import java.io.InputStream;
import org.apache.arrow.compression.CommonsCompressionFactory;
import org.apache.arrow.vector.compression.CompressionCodec;

public class ArrowReaderFactory {
    public static ArrowReader getRecordBatchReader(InputStream is, ReaderOptions options) {
        if (options.isReuseBatch()) {
            if (options.getCompressionCodec().equals(CompressionCodec.NO_COMPRESSION)) {
                return new ArrowBatchReusedReader(is, options.getBufferAllocator());
            }
            return new ArrowBatchReusedReader(is, options.getBufferAllocator(), (CompressionCodec.Factory)CommonsCompressionFactory.INSTANCE);
        }
        if (options.getCompressionCodec().equals(CompressionCodec.NO_COMPRESSION)) {
            return new ArrowBatchNonReusedReader(is, options.getBufferAllocator());
        }
        return new ArrowBatchNonReusedReader(is, options.getBufferAllocator(), (CompressionCodec.Factory)CommonsCompressionFactory.INSTANCE);
    }
}

