/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.arrow;

import com.aliyun.odps.table.arrow.ArrowWriter;
import com.aliyun.odps.table.arrow.writers.ArrowBatchWriter;
import com.aliyun.odps.table.configuration.WriterOptions;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.arrow.vector.compression.CompressionUtil;

public class ArrowWriterFactory {
    public static ArrowWriter getRecordBatchWriter(OutputStream os, WriterOptions writerOptions) throws IOException {
        switch (writerOptions.getCompressionCodec()) {
            case NO_COMPRESSION: {
                return new ArrowBatchWriter(os);
            }
            case ZSTD: {
                return new ArrowBatchWriter(os, CompressionUtil.CodecType.ZSTD);
            }
            case LZ4_FRAME: {
                return new ArrowBatchWriter(os, CompressionUtil.CodecType.LZ4_FRAME);
            }
        }
        throw new IllegalArgumentException("Unsupported compression codec: " + writerOptions.getCompressionCodec());
    }
}

