/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.arrow.constructor;

import com.aliyun.odps.table.arrow.constructor.ArrowFieldWriter;
import com.aliyun.odps.table.utils.Preconditions;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.ListVector;

public abstract class ArrowArrayWriter<IN, TYPE_ARRAY>
extends ArrowFieldWriter<IN> {
    protected final ListVector listVector;
    protected ArrowFieldWriter<TYPE_ARRAY> elementWriter;

    public ArrowArrayWriter(ListVector listVector, ArrowFieldWriter<TYPE_ARRAY> elementWriter) {
        super((ValueVector)listVector);
        this.listVector = listVector;
        this.elementWriter = (ArrowFieldWriter)Preconditions.checkNotNull(elementWriter, (String)"Array element writer");
    }

    protected abstract TYPE_ARRAY readArray(IN var1, int var2);

    protected abstract int numElements(TYPE_ARRAY var1);

    @Override
    protected void setValue(IN in, int ordinal) {
        ((ListVector)this.valueVector).startNewValue(this.getCount());
        TYPE_ARRAY array = this.readArray(in, ordinal);
        int size = this.numElements(array);
        for (int i = 0; i < size; ++i) {
            this.elementWriter.write(array, i);
        }
        ((ListVector)this.valueVector).endValue(this.getCount(), size);
    }

    @Override
    protected void setNull() {
    }

    @Override
    public void finish() {
        super.finish();
        this.elementWriter.finish();
    }

    @Override
    public void reset() {
        super.reset();
        this.elementWriter.reset();
    }
}

