/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.arrow.constructor;

import com.aliyun.odps.table.arrow.constructor.ArrowFieldWriter;
import com.aliyun.odps.table.utils.Preconditions;
import org.apache.arrow.vector.VectorSchemaRoot;

public class ArrowBatchConstructor<IN> {
    private final VectorSchemaRoot root;
    private final ArrowFieldWriter<IN>[] fieldWriters;

    public ArrowBatchConstructor(VectorSchemaRoot root, ArrowFieldWriter<IN>[] fieldWriters) {
        this.root = (VectorSchemaRoot)Preconditions.checkNotNull((Object)root, (String)"Vector schema root");
        this.fieldWriters = (ArrowFieldWriter[])Preconditions.checkNotNull(fieldWriters, (String)"Field writers");
    }

    public void write(IN row) {
        for (int i = 0; i < this.fieldWriters.length; ++i) {
            this.fieldWriters[i].write(row, i);
        }
    }

    public void finish() {
        this.root.setRowCount(this.fieldWriters[0].getCount());
        for (ArrowFieldWriter<IN> fieldWriter : this.fieldWriters) {
            fieldWriter.finish();
        }
    }

    public void reset() {
        this.root.setRowCount(0);
        for (ArrowFieldWriter<IN> fieldWriter : this.fieldWriters) {
            fieldWriter.reset();
        }
    }

    public VectorSchemaRoot getVectorSchemaRoot() {
        return this.root;
    }
}

