/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.arrow.constructor;

import com.aliyun.odps.table.arrow.constructor.ArrowFieldWriter;
import com.aliyun.odps.table.utils.Preconditions;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.StructVector;

public abstract class ArrowStructWriter<IN, TYPE_STRUCT>
extends ArrowFieldWriter<IN> {
    protected ArrowFieldWriter<TYPE_STRUCT>[] fieldsWriters;

    public ArrowStructWriter(StructVector valueVector, ArrowFieldWriter<TYPE_STRUCT>[] fieldsWriters) {
        super((ValueVector)valueVector);
        this.fieldsWriters = (ArrowFieldWriter[])Preconditions.checkNotNull(fieldsWriters, (String)"Struct field writer");
    }

    protected abstract TYPE_STRUCT readStruct(IN var1, int var2);

    @Override
    protected void setValue(IN in, int ordinal) {
        TYPE_STRUCT struct = this.readStruct(in, ordinal);
        ((StructVector)this.valueVector).setIndexDefined(this.count);
        for (int i = 0; i < this.fieldsWriters.length; ++i) {
            this.fieldsWriters[i].write(struct, i);
        }
    }

    @Override
    protected void setNull() {
        for (int i = 0; i < this.fieldsWriters.length; ++i) {
            this.fieldsWriters[i].setNull();
            ++this.fieldsWriters[i].count;
        }
        ((StructVector)this.valueVector).setNull(this.count);
    }

    @Override
    public void finish() {
        super.finish();
        for (ArrowFieldWriter<TYPE_STRUCT> fieldsWriter : this.fieldsWriters) {
            fieldsWriter.finish();
        }
    }

    @Override
    public void reset() {
        super.reset();
        for (ArrowFieldWriter<TYPE_STRUCT> fieldsWriter : this.fieldsWriters) {
            fieldsWriter.reset();
        }
    }
}

