/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.arrow.readers;

import com.aliyun.odps.table.arrow.ArrowReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.arrow.flatbuf.Message;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.compression.CompressionCodec;
import org.apache.arrow.vector.compression.NoCompressionCodec;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.message.ArrowDictionaryBatch;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.MessageChannelReader;
import org.apache.arrow.vector.ipc.message.MessageResult;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.MetadataVersion;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.DictionaryUtility;
import org.apache.arrow.vector.util.VectorBatchAppender;
import org.apache.arrow.vector.validate.MetadataV4UnionChecker;

public class ArrowBatchNonReusedReader
implements ArrowReader {
    private final BufferAllocator allocator;
    private final MessageChannelReader messageReader;
    private final CompressionCodec.Factory compressionFactory;
    private boolean initialized = false;
    private int loadedDictionaryCount;
    private Map<Long, Dictionary> dictionaries;
    private VectorSchemaRoot currentBatch;
    private Schema originalSchema;
    private List<Field> fieldList;

    public ArrowBatchNonReusedReader(InputStream is, BufferAllocator allocator) {
        this(is, allocator, (CompressionCodec.Factory)NoCompressionCodec.Factory.INSTANCE);
    }

    public ArrowBatchNonReusedReader(InputStream is, BufferAllocator allocator, CompressionCodec.Factory compressionFactory) {
        this.allocator = allocator;
        this.compressionFactory = compressionFactory;
        this.messageReader = new MessageChannelReader(new ReadChannel(Channels.newChannel(is)), this.allocator);
        this.currentBatch = null;
    }

    @Override
    public VectorSchemaRoot getCurrentValue() {
        return this.currentBatch;
    }

    @Override
    public boolean nextBatch() throws IOException {
        boolean hasNext = this.loadNextBatch();
        if (!hasNext) {
            this.currentBatch = null;
        }
        return hasNext;
    }

    @Override
    public void close() throws IOException {
        if (this.initialized) {
            for (Dictionary dictionary : this.dictionaries.values()) {
                dictionary.getVector().close();
            }
        }
        this.messageReader.close();
    }

    @Override
    public long bytesRead() {
        return this.messageReader.bytesRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadNextBatch() throws IOException {
        this.prepareLoadNextBatch();
        MessageResult result = this.messageReader.readNext();
        if (result == null) {
            return false;
        }
        if (result.getMessage().headerType() == 3) {
            ArrowBuf bodyBuffer = result.getBodyBuffer();
            if (bodyBuffer == null) {
                bodyBuffer = this.allocator.getEmpty();
            }
            VectorLoader loader = new VectorLoader(this.currentBatch, this.compressionFactory);
            try (ArrowRecordBatch batch = MessageSerializer.deserializeRecordBatch((Message)result.getMessage(), (ArrowBuf)bodyBuffer);){
                loader.load(batch);
            }
            this.checkDictionaries();
            return true;
        }
        if (result.getMessage().headerType() == 2) {
            ArrowDictionaryBatch dictionaryBatch = this.readDictionary(result);
            this.loadDictionary(dictionaryBatch);
            ++this.loadedDictionaryCount;
            return this.loadNextBatch();
        }
        throw new IOException("Expected RecordBatch or DictionaryBatch but header was " + result.getMessage().headerType());
    }

    private void prepareLoadNextBatch() throws IOException {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        ArrayList<FieldVector> vectors = new ArrayList<FieldVector>(this.fieldList.size());
        for (Field field : this.fieldList) {
            vectors.add(field.createVector(this.allocator));
        }
        Schema schema = new Schema(this.fieldList, this.originalSchema.getCustomMetadata());
        this.currentBatch = new VectorSchemaRoot(schema, vectors, 0);
        this.currentBatch.setRowCount(0);
    }

    private void initialize() throws IOException {
        this.originalSchema = this.readSchema();
        this.fieldList = new ArrayList<Field>(this.originalSchema.getFields().size());
        HashMap dictionaries = new HashMap();
        for (Field field : this.originalSchema.getFields()) {
            Field updated = DictionaryUtility.toMemoryFormat((Field)field, (BufferAllocator)this.allocator, dictionaries);
            this.fieldList.add(updated);
        }
        this.dictionaries = Collections.unmodifiableMap(dictionaries);
    }

    private Schema readSchema() throws IOException {
        MessageResult result = this.messageReader.readNext();
        if (result == null) {
            throw new IOException("Unexpected end of input. Missing schema.");
        }
        if (result.getMessage().headerType() != 1) {
            throw new IOException("Expected schema but header was " + result.getMessage().headerType());
        }
        Schema schema = MessageSerializer.deserializeSchema((Message)result.getMessage());
        MetadataV4UnionChecker.checkRead((Schema)schema, (MetadataVersion)MetadataVersion.fromFlatbufID((short)result.getMessage().version()));
        return schema;
    }

    private ArrowDictionaryBatch readDictionary(MessageResult result) throws IOException {
        ArrowBuf bodyBuffer = result.getBodyBuffer();
        if (bodyBuffer == null) {
            bodyBuffer = this.allocator.getEmpty();
        }
        return MessageSerializer.deserializeDictionaryBatch((Message)result.getMessage(), (ArrowBuf)bodyBuffer);
    }

    private void loadDictionary(ArrowDictionaryBatch dictionaryBatch) {
        long id = dictionaryBatch.getDictionaryId();
        Dictionary dictionary = this.dictionaries.get(id);
        if (dictionary == null) {
            throw new IllegalArgumentException("Dictionary ID " + id + " not defined in schema");
        }
        FieldVector vector = dictionary.getVector();
        if (dictionaryBatch.isDelta()) {
            try (FieldVector deltaVector = vector.getField().createVector(this.allocator);){
                this.load(dictionaryBatch, deltaVector);
                VectorBatchAppender.batchAppend((ValueVector)vector, (ValueVector[])new FieldVector[]{deltaVector});
            }
            return;
        }
        this.load(dictionaryBatch, vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(ArrowDictionaryBatch dictionaryBatch, FieldVector vector) {
        VectorSchemaRoot root = new VectorSchemaRoot(Collections.singletonList(vector.getField()), Collections.singletonList(vector), 0);
        VectorLoader loader = new VectorLoader(root);
        try {
            loader.load(dictionaryBatch.getDictionary());
        }
        finally {
            dictionaryBatch.close();
        }
    }

    private void checkDictionaries() throws IOException {
        if (this.loadedDictionaryCount == this.dictionaries.size()) {
            return;
        }
        for (FieldVector vector : this.currentBatch.getFieldVectors()) {
            DictionaryEncoding encoding = vector.getField().getDictionary();
            if (encoding == null || this.dictionaries.containsKey(encoding.getId()) || vector.getNullCount() >= vector.getValueCount()) continue;
            throw new IOException("The dictionary was not available, id was:" + encoding.getId());
        }
    }
}

