/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.arrow.writers;

import com.aliyun.odps.table.arrow.ArrowWriter;
import com.aliyun.odps.table.arrow.writers.ArrowCompressVectorUnloader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import org.apache.arrow.compression.CommonsCompressionFactory;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.compression.CompressionUtil;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.MetadataVersion;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.validate.MetadataV4UnionChecker;

public class ArrowBatchWriter
implements ArrowWriter {
    private final WriteChannel out;
    private final IpcOption option;
    private boolean started;
    private boolean ended;
    private final CompressionUtil.CodecType codecType;

    public ArrowBatchWriter(OutputStream out) {
        this(out, new IpcOption());
    }

    public ArrowBatchWriter(OutputStream out, IpcOption option) {
        this(out, option, CompressionUtil.CodecType.NO_COMPRESSION);
    }

    public ArrowBatchWriter(OutputStream out, CompressionUtil.CodecType codecType) {
        this(out, new IpcOption(), codecType);
    }

    public ArrowBatchWriter(OutputStream out, IpcOption option, CompressionUtil.CodecType codecType) {
        this.out = new WriteChannel(Channels.newChannel(out));
        this.option = option;
        this.started = false;
        this.ended = false;
        this.codecType = codecType;
    }

    @Override
    public void writeBatch(VectorSchemaRoot root) throws IOException {
        Object unloader = this.codecType.equals((Object)CompressionUtil.CodecType.NO_COMPRESSION) ? new VectorUnloader(root) : new ArrowCompressVectorUnloader(root, true, CommonsCompressionFactory.INSTANCE.createCodec(this.codecType), true);
        this.ensureStarted(root);
        try (ArrowRecordBatch batch = unloader.getRecordBatch();){
            MessageSerializer.serialize((WriteChannel)this.out, (ArrowRecordBatch)batch, (IpcOption)this.option);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.started) {
                this.ensureEnded();
            }
            this.out.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public long bytesWritten() {
        return this.out.getCurrentPosition();
    }

    private void ensureStarted(VectorSchemaRoot root) throws IOException {
        if (!this.started) {
            this.started = true;
            MetadataV4UnionChecker.checkForUnion(root.getSchema().getFields().iterator(), (MetadataVersion)this.option.metadataVersion);
            MessageSerializer.serialize((WriteChannel)this.out, (Schema)root.getSchema(), (IpcOption)this.option);
        }
    }

    private void ensureEnded() throws IOException {
        if (!this.ended) {
            this.ended = true;
            if (!this.option.write_legacy_ipc_format) {
                this.out.writeIntLittleEndian(-1);
            }
            this.out.writeIntLittleEndian(0);
        }
    }
}

