/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.arrow.writers;

import com.aliyun.odps.table.arrow.writers.ArrowCompressRecordBatch;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.TypeLayout;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.compression.CompressionCodec;
import org.apache.arrow.vector.compression.CompressionUtil;
import org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.ArrowType;

class ArrowCompressVectorUnloader
extends VectorUnloader {
    private final VectorSchemaRoot root;
    private final boolean includeNullCount;
    private final CompressionCodec codec;
    private final boolean alignBuffers;

    ArrowCompressVectorUnloader(VectorSchemaRoot root, boolean includeNullCount, CompressionCodec codec, boolean alignBuffers) {
        super(root, includeNullCount, codec, alignBuffers);
        this.root = root;
        this.includeNullCount = includeNullCount;
        this.codec = codec;
        this.alignBuffers = alignBuffers;
    }

    public ArrowRecordBatch getRecordBatch() {
        ArrayList<ArrowFieldNode> nodes = new ArrayList<ArrowFieldNode>();
        ArrayList<ArrowBuf> buffers = new ArrayList<ArrowBuf>();
        for (FieldVector vector : this.root.getFieldVectors()) {
            this.appendNodes(vector, nodes, buffers);
        }
        return new ArrowCompressRecordBatch(this.root.getRowCount(), nodes, buffers, CompressionUtil.createBodyCompression((CompressionCodec)this.codec), this.alignBuffers);
    }

    private void appendNodes(FieldVector vector, List<ArrowFieldNode> nodes, List<ArrowBuf> buffers) {
        nodes.add(new ArrowFieldNode((long)vector.getValueCount(), this.includeNullCount ? (long)vector.getNullCount() : -1L));
        List fieldBuffers = vector.getFieldBuffers();
        int expectedBufferCount = TypeLayout.getTypeBufferCount((ArrowType)vector.getField().getType());
        if (fieldBuffers.size() != expectedBufferCount) {
            throw new IllegalArgumentException(String.format("wrong number of buffers for field %s in vector %s. found: %s", vector.getField(), vector.getClass().getSimpleName(), fieldBuffers));
        }
        for (ArrowBuf buf : fieldBuffers) {
            buf.getReferenceManager().retain();
            buffers.add(this.codec.compress(vector.getAllocator(), buf));
        }
        for (FieldVector child : vector.getChildrenFromFields()) {
            this.appendNodes(child, nodes, buffers);
        }
    }
}

