/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.configuration;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CompressionCodec implements Serializable
{
    NO_COMPRESSION(""),
    ZSTD("ZSTD"),
    LZ4_FRAME("LZ4_FRAME");

    private final String codecName;
    private static final Map<String, CompressionCodec> CODEC_MAP;

    private CompressionCodec(String codecName) {
        this.codecName = codecName;
    }

    public String toString() {
        return this.codecName;
    }

    public static Optional<CompressionCodec> byName(String name) {
        return Optional.ofNullable(CODEC_MAP.get(name.toUpperCase()));
    }

    static {
        CODEC_MAP = Arrays.stream(CompressionCodec.values()).collect(Collectors.toMap(v -> v.codecName, Function.identity()));
    }
}

