/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.configuration;

import java.io.Serializable;

public class DynamicPartitionOptions
implements Serializable {
    public static final int DEFAULT_DYNAMIC_PARTITION_LIMIT = 512;
    public static final int DEFAULT_INVALID_LIMIT = 100;
    public static final InvalidStrategy DEFAULT_INVALID_STRATEGY = InvalidStrategy.EXCEPTION;
    private InvalidStrategy invalidStrategy = DEFAULT_INVALID_STRATEGY;
    private int invalidLimit = 100;
    private int dynamicPartitionLimit = 512;

    private DynamicPartitionOptions() {
    }

    public int getDynamicPartitionLimit() {
        return this.dynamicPartitionLimit;
    }

    public long getInvalidLimit() {
        return this.invalidLimit;
    }

    public InvalidStrategy getInvalidStrategy() {
        return this.invalidStrategy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static DynamicPartitionOptions createDefault() {
        return new Builder().build();
    }

    public static enum InvalidStrategy {
        DROP,
        LIMIT,
        EXCEPTION;


        public String toString() {
            switch (this) {
                case DROP: {
                    return "Drop";
                }
                case LIMIT: {
                    return "Limit";
                }
                case EXCEPTION: {
                    return "Exception";
                }
            }
            throw new IllegalArgumentException("Unexpected invalid strategy");
        }
    }

    public static class Builder {
        private final DynamicPartitionOptions options = new DynamicPartitionOptions();

        public Builder withInvalidStrategy(InvalidStrategy invalidStrategy) {
            this.options.invalidStrategy = invalidStrategy;
            return this;
        }

        public Builder withInvalidLimit(int invalidLimit) {
            this.options.invalidLimit = invalidLimit;
            return this;
        }

        public Builder withDynamicPartitionLimit(int dynamicPartitionLimit) {
            this.options.dynamicPartitionLimit = dynamicPartitionLimit;
            return this;
        }

        public DynamicPartitionOptions build() {
            return this.options;
        }
    }
}

