/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.table.configuration;

import com.aliyun.odps.table.utils.Preconditions;

public class SplitOptions {
    private static final long DEFAULT_SPLIT_SIZE = 0x10000000L;
    private static final boolean DEFAULT_CROSS_PARTITION = true;
    private static final SplitMode DEFAULT_SPLIT_MODE = SplitMode.SIZE;
    private SplitMode splitMode = DEFAULT_SPLIT_MODE;
    private long splitNumber = 0x10000000L;
    private boolean crossPartition = true;
    private int splitMaxFileNum;

    private SplitOptions() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static SplitOptions createDefault() {
        return new Builder().SplitByByteSize(0x10000000L).build();
    }

    public boolean isCrossPartition() {
        return this.crossPartition;
    }

    public long getSplitNumber() {
        return this.splitNumber;
    }

    public SplitMode getSplitMode() {
        return this.splitMode;
    }

    public int getSplitMaxFileNum() {
        return this.splitMaxFileNum;
    }

    public static enum SplitMode {
        SIZE,
        PARALLELISM,
        ROW_OFFSET,
        BUCKET;


        public String toString() {
            switch (this) {
                case SIZE: {
                    return "Size";
                }
                case PARALLELISM: {
                    return "Parallelism";
                }
                case ROW_OFFSET: {
                    return "RowOffset";
                }
                case BUCKET: {
                    return "Bucket";
                }
            }
            throw new IllegalArgumentException("Unexpected split mode");
        }
    }

    public static class Builder {
        private SplitOptions splitOptions;

        public Builder SplitByByteSize(long splitByteSize) {
            Preconditions.checkLong((Long)splitByteSize, (long)0xA00000L, (String)"splitByteSize");
            this.splitOptions = new SplitOptions();
            this.splitOptions.splitNumber = splitByteSize;
            this.splitOptions.splitMode = SplitMode.SIZE;
            return this;
        }

        public Builder SplitByParallelism(long splitParallelism) {
            Preconditions.checkLong((Long)splitParallelism, (long)1L, (String)"splitParallelism");
            this.splitOptions = new SplitOptions();
            this.splitOptions.splitNumber = splitParallelism;
            this.splitOptions.splitMode = SplitMode.PARALLELISM;
            return this;
        }

        public Builder SplitByRowOffset() {
            this.splitOptions = new SplitOptions();
            this.splitOptions.splitMode = SplitMode.ROW_OFFSET;
            return this;
        }

        public Builder SplitByBucket() {
            this.splitOptions = new SplitOptions();
            this.splitOptions.splitMode = SplitMode.BUCKET;
            return this;
        }

        public Builder withCrossPartition(boolean crossPartition) {
            Preconditions.checkNotNull((Object)this.splitOptions, (String)"Split option");
            this.splitOptions.crossPartition = crossPartition;
            return this;
        }

        public Builder withMaxFileNum(int splitMaxFileNum) {
            this.splitOptions.splitMaxFileNum = splitMaxFileNum;
            return this;
        }

        public SplitOptions build() {
            return this.splitOptions;
        }
    }
}

